/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenAcacia
extends WorldGenTree {
    public WorldGenAcacia(ITreeGenData tree) {
        super(tree, 5, 2);
    }

    @Override
    public void generate(World world) {
        WorldGenArboriculture.Direction leanDirection = WorldGenArboriculture.Direction.getRandom(world.rand);
        float leanAmount = (float)this.height / 4.0f;
        List<ChunkCoordinates> treeTops = this.generateTreeTrunk(world, this.height, this.girth, 0.0f, leanDirection.forgeDirection, leanAmount);
        if (this.height > 5 && world.rand.nextBoolean()) {
            WorldGenArboriculture.Direction branchDirection = WorldGenArboriculture.Direction.getRandomOther(world.rand, leanDirection);
            List<ChunkCoordinates> treeTops2 = this.generateTreeTrunk(world, Math.round((float)this.height * 0.66f), this.girth, 0.0f, branchDirection.forgeDirection, leanAmount);
            treeTops.addAll(treeTops2);
        }
        ArrayList<ChunkCoordinates> branchLocations = new ArrayList<ChunkCoordinates>();
        for (ChunkCoordinates treeTop : treeTops) {
            int xOffset = treeTop.posX;
            int yOffset = treeTop.posY + 1;
            int zOffset = treeTop.posZ;
            float canopyMultiplier = (1.5f * (float)this.height - (float)yOffset + 2.0f) / 4.0f;
            int canopyThickness = Math.max(1, Math.round((float)yOffset / 10.0f));
            this.generateAdjustedCylinder(world, yOffset--, xOffset, zOffset, canopyMultiplier, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
            float canopyWidth = world.rand.nextBoolean() ? 3.0f : 2.5f;
            List<ChunkCoordinates> branches = this.generateBranches(world, yOffset - canopyThickness, xOffset, zOffset, 0.0f, 0.1f, Math.round(canopyMultiplier * canopyWidth - 4.0f), 2);
            branchLocations.addAll(branches);
        }
        for (ChunkCoordinates branchLocation : branchLocations) {
            int leafSpawn = branchLocation.posY;
            int canopyThickness = Math.max(1, Math.round((float)leafSpawn / 10.0f));
            float canopyMultiplier = (1.5f * (float)this.height - (float)leafSpawn + 2.0f) / 4.0f;
            float canopyWidth = world.rand.nextBoolean() ? 1.0f : 1.5f;
            this.generateAdjustedCylinder(world, leafSpawn - canopyThickness + 1, branchLocation.posX, branchLocation.posZ, canopyMultiplier * canopyWidth, canopyThickness, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }
}

