/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.render;

import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.render.RenderOverlayBlock;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RenderLeavesBlock
extends RenderOverlayBlock {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileLeaves tile = BlockForestryLeaves.getLeafTile(world, x, y, z);
        if (tile == null) {
            return false;
        }
        renderer.renderStandardBlock(block, x, y, z);
        IIcon fruitIcon = tile.getFruitTexture();
        if (fruitIcon != null) {
            int fruitColor = tile.getFruitColour();
            RenderLeavesBlock.renderFruitOverlay(world, block, x, y, z, renderer, fruitIcon, fruitColor);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return PluginArboriculture.modelIdLeaves;
    }

    private static boolean renderFruitOverlay(IBlockAccess world, Block block, int x, int y, int z, RenderBlocks renderer, IIcon texture, int multiplier) {
        float mR = (float)(multiplier >> 16 & 0xFF) / 255.0f;
        float mG = (float)(multiplier >> 8 & 0xFF) / 255.0f;
        float mB = (float)(multiplier & 0xFF) / 255.0f;
        if (EntityRenderer.anaglyphEnable) {
            mR = (mR * 30.0f + mG * 59.0f + mB * 11.0f) / 100.0f;
            mG = (mR * 30.0f + mG * 70.0f) / 100.0f;
            mB = (mR * 30.0f + mB * 70.0f) / 100.0f;
        }
        return RenderLeavesBlock.renderFruitOverlayWithColorMultiplier(world, block, x, y, z, mR, mG, mB, renderer, texture);
    }

    private static boolean renderFruitOverlayWithColorMultiplier(IBlockAccess world, Block block, int x, int y, int z, float r, float g, float b, RenderBlocks renderer, IIcon texture) {
        int mixedBrightness = block.getMixedBrightnessForBlock(world, x, y, z);
        float adjR = 0.5f * r;
        float adjG = 0.5f * g;
        float adjB = 0.5f * b;
        RenderLeavesBlock.renderBottomFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        RenderLeavesBlock.renderTopFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        RenderLeavesBlock.renderEastFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        RenderLeavesBlock.renderWestFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        RenderLeavesBlock.renderNorthFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        RenderLeavesBlock.renderSouthFace(world, block, x, y, z, renderer, texture, mixedBrightness, adjR, adjG, adjB);
        return true;
    }
}

