/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.ITreeGenome;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.core.utils.StringUtil;
import java.util.EnumSet;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class GrowthProviderTropical
extends GrowthProvider {
    @Override
    public EnumGrowthConditions getGrowthConditions(ITreeGenome genome, World world, int xPos, int yPos, int zPos) {
        EnumGrowthConditions light = GrowthProviderTropical.getConditionFromLight(world, xPos, yPos, zPos);
        EnumGrowthConditions moisture = GrowthProviderTropical.getConditionsFromRainfall(world, xPos, yPos, zPos, BiomeGenBase.jungle.rainfall, 2.0f);
        float jungleTemperature = BiomeGenBase.jungle.getFloatTemperature(xPos, yPos, zPos);
        float desertTemperature = BiomeGenBase.desert.getFloatTemperature(xPos, yPos, zPos);
        EnumGrowthConditions temperature = GrowthProviderTropical.getConditionsFromTemperature(world, xPos, yPos, zPos, jungleTemperature, desertTemperature - 0.1f);
        EnumSet<EnumGrowthConditions> conditions = EnumSet.of(light, moisture, temperature);
        EnumGrowthConditions result = EnumGrowthConditions.HOSTILE;
        for (EnumGrowthConditions cond : conditions) {
            if (cond == EnumGrowthConditions.HOSTILE) {
                return EnumGrowthConditions.HOSTILE;
            }
            if (cond.ordinal() <= result.ordinal()) continue;
            result = cond;
        }
        return result;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("growth.tropical");
    }
}

