/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.core.commands.SpeciesNotFoundException;
import forestry.core.commands.TemplateNotFoundException;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.gen.feature.WorldGenerator;

public final class TreeGenHelper {
    public static WorldGenerator getWorldGen(String treeName, EntityPlayer player, int x, int y, int z) {
        ITreeGenome treeGenome = TreeGenHelper.getTreeGenome(treeName);
        if (treeGenome == null) {
            return null;
        }
        ITree tree = TreeManager.treeRoot.getTree(player.worldObj, treeGenome);
        return tree.getTreeGenerator(player.worldObj, x, y, z, true);
    }

    public static void generateTree(WorldGenerator gen, EntityPlayer player, int x, int y, int z) {
        if (gen instanceof WorldGenBase) {
            ((WorldGenBase)gen).generate(player.worldObj, x, y, z, true);
        } else {
            gen.generate(player.worldObj, player.worldObj.rand, x, y, z);
        }
    }

    private static ITreeGenome getTreeGenome(String speciesName) {
        IAllele species = null;
        for (String uid : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
            IAllele allele;
            if (!uid.equals(speciesName) || !((allele = AlleleManager.alleleRegistry.getAllele(uid)) instanceof IAlleleTreeSpecies)) continue;
            species = (IAlleleTreeSpecies)allele;
            break;
        }
        if (species == null) {
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(allele instanceof IAlleleTreeSpecies) || !allele.getName().replaceAll("\\s", "").equals(speciesName)) continue;
                species = (IAlleleTreeSpecies)allele;
                break;
            }
        }
        if (species == null) {
            throw new SpeciesNotFoundException(speciesName);
        }
        IAllele[] template = TreeManager.treeRoot.getTemplate(species.getUID());
        if (template == null) {
            throw new TemplateNotFoundException((IAlleleSpecies)species);
        }
        return TreeManager.treeRoot.templateAsGenome(template);
    }
}

