/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.core.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.gui.ContainerAlvearyHygroregulator;
import forestry.apiculture.gui.GuiAlvearyHygroregulator;
import forestry.apiculture.inventory.InventoryHygroregulator;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.ILiquidTankTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileAlvearyHygroregulator
extends TileAlveary
implements IInventory,
ILiquidTankTile,
IFluidHandler,
IAlvearyComponent.Climatiser {
    private final HygroregulatorRecipe[] recipes;
    private final TankManager tankManager;
    private final FilteredTank liquidTank;
    private final IInventoryAdapter inventory = new InventoryHygroregulator(this);
    private HygroregulatorRecipe currentRecipe;
    private int transferTime;

    public TileAlvearyHygroregulator() {
        super(BlockAlveary.Type.HYGRO);
        Fluid water = Fluids.WATER.getFluid();
        Fluid lava = Fluids.LAVA.getFluid();
        Fluid liquidIce = Fluids.ICE.getFluid();
        this.liquidTank = new FilteredTank(10000, water, lava, liquidIce);
        this.tankManager = new TankManager(this, this.liquidTank);
        this.recipes = new HygroregulatorRecipe[]{new HygroregulatorRecipe(new FluidStack(water, 1), 1, 0.01f, -0.005f), new HygroregulatorRecipe(new FluidStack(lava, 1), 10, -0.01f, 0.005f), new HygroregulatorRecipe(new FluidStack(liquidIce, 1), 10, 0.02f, -0.01f)};
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    private HygroregulatorRecipe getRecipe(FluidStack liquid) {
        HygroregulatorRecipe recipe = null;
        for (HygroregulatorRecipe rec : this.recipes) {
            if (!rec.liquid.isFluidEqual(liquid)) continue;
            recipe = rec;
            break;
        }
        return recipe;
    }

    @Override
    public void changeClimate(int tickCount, IClimateControlled climateControlled) {
        if (this.transferTime <= 0 && this.liquidTank.getFluidAmount() > 0) {
            this.currentRecipe = this.getRecipe(this.liquidTank.getFluid());
            if (this.currentRecipe != null) {
                this.liquidTank.drain(this.currentRecipe.liquid.amount, true);
                this.transferTime = this.currentRecipe.transferTime;
            }
        }
        if (this.transferTime > 0) {
            --this.transferTime;
            if (this.currentRecipe != null) {
                climateControlled.addHumidityChange(this.currentRecipe.humidChange, 0.0f, 1.0f);
                climateControlled.addTemperatureChange(this.currentRecipe.tempChange, 0.0f, 2.0f);
            } else {
                this.transferTime = 0;
            }
        }
        if (tickCount % 20 == 0) {
            FluidHelper.drainContainers(this.tankManager, this, 0);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.transferTime = nbttagcompound.getInteger("TransferTime");
        if (nbttagcompound.hasKey("CurrentLiquid")) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound.getCompoundTag("CurrentLiquid"));
            this.currentRecipe = this.getRecipe(liquid);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("TransferTime", this.transferTime);
        if (this.currentRecipe != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.currentRecipe.liquid.writeToNBT(subcompound);
            nbttagcompound.setTag("CurrentLiquid", (NBTBase)subcompound);
        }
    }

    @Override
    public int getIcon(int side) {
        return 11;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiAlvearyHygroregulator(player.inventory, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerAlvearyHygroregulator(player.inventory, this);
    }

    private static class HygroregulatorRecipe {
        public final FluidStack liquid;
        public final int transferTime;
        public final float humidChange;
        public final float tempChange;

        public HygroregulatorRecipe(FluidStack liquid, int transferTime, float humidChange, float tempChange) {
            this.liquid = liquid;
            this.transferTime = transferTime;
            this.humidChange = humidChange;
            this.tempChange = tempChange;
        }
    }
}

