/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.Tabs;
import forestry.core.items.ItemForestry;
import net.minecraft.item.ItemStack;

public class ItemHiveFrame
extends ItemForestry
implements IHiveFrame {
    private final IBeeModifier beeModifier;

    public ItemHiveFrame(int maxDamage, float geneticDecay) {
        this.setMaxStackSize(1);
        this.setMaxDamage(maxDamage);
        this.setCreativeTab(Tabs.tabApiculture);
        this.beeModifier = new HiveFrameBeeModifier(geneticDecay);
    }

    @Override
    public ItemStack frameUsed(IBeeHousing housing, ItemStack frame, IBee queen, int wear) {
        frame.setItemDamage(frame.getItemDamage() + wear);
        if (frame.getItemDamage() >= frame.getMaxDamage()) {
            return null;
        }
        return frame;
    }

    @Override
    public IBeeModifier getBeeModifier() {
        return this.beeModifier;
    }

    private static class HiveFrameBeeModifier
    extends DefaultBeeModifier {
        private final float geneticDecay;

        public HiveFrameBeeModifier(float geneticDecay) {
            this.geneticDecay = geneticDecay;
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return currentModifier < 10.0f ? 2.0f : 1.0f;
        }

        @Override
        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return this.geneticDecay;
        }
    }
}

