/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.gui.ContainerImprinter;
import forestry.apiculture.inventory.ItemInventoryImprinter;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GuiImprinter
extends GuiForestry<ContainerImprinter, ItemInventoryImprinter> {
    private int startX;
    private int startY;
    private final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    public GuiImprinter(InventoryPlayer inventoryplayer, ItemInventoryImprinter inventory) {
        super("textures/gui/imprinter.png", new ContainerImprinter(inventoryplayer, inventory), inventory);
        this.xSize = 176;
        this.ySize = 185;
        ArrayList beeList = new ArrayList();
        PluginApiculture.items.beeDroneGE.addCreativeItems(beeList, false);
        for (ItemStack beeStack : beeList) {
            IAlleleBeeSpecies species = BeeGenome.getSpecies(beeStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), beeStack);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        int offset = (138 - this.fontRendererObj.getStringWidth(StringUtil.localize("gui.imprinter.name"))) / 2;
        this.fontRendererObj.drawString(StringUtil.localize("gui.imprinter.name"), this.startX + 8 + offset, this.startY + 16, this.fontColor.get("gui.screen"));
        IAlleleBeeSpecies primary = ((ItemInventoryImprinter)this.inventory).getPrimary();
        this.drawBeeSpeciesIcon(primary, this.startX + 12, this.startY + 32);
        this.fontRendererObj.drawString(primary.getName(), this.startX + 32, this.startY + 36, this.fontColor.get("gui.screen"));
        IAlleleBeeSpecies secondary = ((ItemInventoryImprinter)this.inventory).getSecondary();
        this.drawBeeSpeciesIcon(secondary, this.startX + 12, this.startY + 52);
        this.fontRendererObj.drawString(secondary.getName(), this.startX + 32, this.startY + 56, this.fontColor.get("gui.screen"));
        String youCheater = StringUtil.localize("gui.imprinter.cheater");
        offset = (138 - this.fontRendererObj.getStringWidth(youCheater)) / 2;
        this.fontRendererObj.drawString(youCheater, this.startX + 8 + offset, this.startY + 76, this.fontColor.get("gui.screen"));
    }

    private void drawBeeSpeciesIcon(IAlleleBeeSpecies bee, int x, int y) {
        GuiUtil.drawItemStack(this, this.iconStacks.get(bee.getUID()), x, y);
    }

    private static int getHabitatSlotAtPosition(int i, int j) {
        int[] xPos = new int[]{12, 12};
        int[] yPos = new int[]{32, 52};
        for (int l = 0; l < xPos.length; ++l) {
            if (i < xPos[l] || i > xPos[l] + 16 || j < yPos[l] || j > yPos[l] + 16) continue;
            return l;
        }
        return -1;
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int cornerX = (this.width - this.xSize) / 2;
        int cornerY = (this.height - this.ySize) / 2;
        int slot = GuiImprinter.getHabitatSlotAtPosition(i - cornerX, j - cornerY);
        if (slot < 0) {
            return;
        }
        if (k == 0) {
            GuiImprinter.advanceSelection(slot);
        } else {
            GuiImprinter.regressSelection(slot);
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.startX = (this.width - this.xSize) / 2;
        this.startY = (this.height - this.ySize) / 2;
    }

    private static void advanceSelection(int index) {
        GuiImprinter.sendSelectionChange(index, 0);
    }

    private static void regressSelection(int index) {
        GuiImprinter.sendSelectionChange(index, 1);
    }

    private static void sendSelectionChange(int index, int advance) {
        Proxies.net.sendToServer(new PacketGuiSelectRequest(index, advance));
    }
}

