/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class GrowthRuleDirtGrass
implements IFlowerGrowthRule {
    @Override
    public boolean growFlower(IFlowerRegistry flowerRegistry, String flowerType, World world, IIndividual individual, int x, int y, int z) {
        if (!world.isAirBlock(x, y, z)) {
            return false;
        }
        Block ground = world.getBlock(x, y - 1, z);
        if (ground != Blocks.dirt && ground != Blocks.grass) {
            return false;
        }
        IFlower flower = flowerRegistry.getRandomPlantableFlower(flowerType, world.rand);
        return world.setBlock(x, y, z, flower.getBlock(), flower.getMeta(), 2);
    }

    @Override
    public boolean growFlower(IFlowerGrowthHelper helper, String flowerType, World world, int x, int y, int z) {
        if (!world.isAirBlock(x, y, z)) {
            return false;
        }
        Block ground = world.getBlock(x, y - 1, z);
        if (ground != Blocks.dirt && ground != Blocks.grass) {
            return false;
        }
        return helper.plantRandomFlower(flowerType, world, x, y, z);
    }
}

