/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.core.access.IAccessHandler;
import forestry.core.inventory.InventoryAdapterRestricted;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.SlotUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryBeeHousing
extends InventoryAdapterRestricted
implements IBeeHousingInventory {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCT_COUNT = 7;

    public InventoryBeeHousing(int size, IAccessHandler accessHandler) {
        super(size, "Items", accessHandler);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        EnumBeeType beeType = BeeManager.beeRoot.getType(itemStack);
        if (slotIndex == 0) {
            return beeType == EnumBeeType.QUEEN || beeType == EnumBeeType.PRINCESS;
        }
        if (slotIndex == 1) {
            return beeType == EnumBeeType.DRONE;
        }
        return false;
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canExtractItem(slotIndex, itemstack, side)) {
            return false;
        }
        return SlotUtil.isSlotInRange(slotIndex, 2, 7);
    }

    @Override
    public final ItemStack getQueen() {
        return this.getStackInSlot(0);
    }

    @Override
    public final ItemStack getDrone() {
        return this.getStackInSlot(1);
    }

    @Override
    public final void setQueen(ItemStack itemstack) {
        this.setInventorySlotContents(0, itemstack);
    }

    @Override
    public final void setDrone(ItemStack itemstack) {
        this.setInventorySlotContents(1, itemstack);
    }

    @Override
    public final boolean addProduct(ItemStack product, boolean all) {
        return InventoryUtil.tryAddStack((IInventory)this, product, 2, 7, all, true);
    }
}

