/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public abstract class MultiblockTileEntityBase<T extends IMultiblockLogic>
extends TileEntity
implements IMultiblockComponent {
    private final T multiblockLogic;

    public MultiblockTileEntityBase(T multiblockLogic) {
        this.multiblockLogic = multiblockLogic;
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.xCoord, this.yCoord, this.zCoord);
    }

    public T getMultiblockLogic() {
        return this.multiblockLogic;
    }

    @Override
    public abstract void onMachineAssembled(IMultiblockController var1, ChunkCoordinates var2, ChunkCoordinates var3);

    @Override
    public abstract void onMachineBroken();

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.multiblockLogic.readFromNBT(data);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.multiblockLogic.writeToNBT(data);
    }

    public boolean canUpdate() {
        return false;
    }

    public final void invalidate() {
        super.invalidate();
        this.multiblockLogic.invalidate(this.worldObj, this);
    }

    public final void onChunkUnload() {
        super.onChunkUnload();
        this.multiblockLogic.onChunkUnload(this.worldObj, this);
    }

    public final void validate() {
        super.validate();
        this.multiblockLogic.validate(this.worldObj, this);
    }

    public final Packet getDescriptionPacket() {
        NBTTagCompound packetData = new NBTTagCompound();
        this.multiblockLogic.encodeDescriptionPacket(packetData);
        this.encodeDescriptionPacket(packetData);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, packetData);
    }

    public final void onDataPacket(NetworkManager network, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbtData = packet.func_148857_g();
        this.multiblockLogic.decodeDescriptionPacket(nbtData);
        this.decodeDescriptionPacket(nbtData);
    }

    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
    }

    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
    }
}

