/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network;

import com.mojang.authlib.GameProfile;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.PacketId;
import forestry.mail.EnumStationState;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.item.ItemStack;

public class PacketLetterInfo
extends ForestryPacket {
    public EnumAddressee type;
    public TradeStationInfo tradeInfo;
    public IMailAddress address;

    public PacketLetterInfo(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketLetterInfo(PacketId id, EnumAddressee type, TradeStationInfo info, IMailAddress address) {
        super(id);
        this.type = type;
        if (type == EnumAddressee.TRADER) {
            this.tradeInfo = info;
        } else if (type == EnumAddressee.PLAYER) {
            this.address = address;
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        if (this.type == null) {
            data.writeShort(-1);
            return;
        }
        data.writeShort(0);
        data.writeUTF(this.type.toString());
        if (this.type == EnumAddressee.PLAYER) {
            if (this.address == null) {
                data.writeShort(-1);
                return;
            }
            data.writeShort(0);
            GameProfile profile = this.address.getPlayerProfile();
            data.writeLong(profile.getId().getMostSignificantBits());
            data.writeLong(profile.getId().getLeastSignificantBits());
            data.writeUTF(profile.getName());
        } else if (this.type == EnumAddressee.TRADER) {
            if (this.tradeInfo == null) {
                data.writeShort(-1);
                return;
            }
            data.writeShort(0);
            data.writeUTF(this.tradeInfo.address.getName());
            data.writeLong(this.tradeInfo.owner.getId().getMostSignificantBits());
            data.writeLong(this.tradeInfo.owner.getId().getLeastSignificantBits());
            data.writeUTF(this.tradeInfo.owner.getName());
            data.writeItemStack(this.tradeInfo.tradegood);
            data.writeItemStacks(this.tradeInfo.required);
            data.writeShort(this.tradeInfo.state.ordinal());
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        if (data.readShort() < 0) {
            return;
        }
        this.type = EnumAddressee.fromString(data.readUTF());
        if (this.type == EnumAddressee.PLAYER) {
            if (data.readShort() < 0) {
                return;
            }
            GameProfile player = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readUTF());
            this.address = PostManager.postRegistry.getMailAddress(player);
        } else if (this.type == EnumAddressee.TRADER) {
            if (data.readShort() < 0) {
                return;
            }
            IMailAddress address = PostManager.postRegistry.getMailAddress(data.readUTF());
            GameProfile owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readUTF());
            ItemStack tradegood = data.readItemStack();
            ItemStack[] required = data.readItemStacks();
            this.tradeInfo = new TradeStationInfo(address, owner, tradegood, required, EnumStationState.values()[data.readShort()]);
        }
    }
}

