/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FakeTank;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileValve
extends TileFarm
implements ILiquidTankContainer {
    public TileValve() {
        this.fixedType = 6;
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        TankManager tankManager = this.getTankManager();
        if (tankManager == null) {
            return FakeTank.INSTANCE.fill(resource, doFill);
        }
        return tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        TankManager tankManager = this.getTankManager();
        if (tankManager == null) {
            return null;
        }
        return tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        TankManager tankManager = this.getTankManager();
        if (tankManager == null) {
            return FakeTank.INSTANCE.drain(maxDrain, doDrain);
        }
        return tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        TankManager tankManager = this.getTankManager();
        if (tankManager == null) {
            return true;
        }
        return tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        TankManager tankManager = this.getTankManager();
        if (tankManager == null) {
            return false;
        }
        return tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        TankManager tankManager = this.getTankManager();
        if (tankManager == null) {
            return FakeTank.INFO;
        }
        return tankManager.getTankInfo(from);
    }

    @Override
    public TankManager getTankManager() {
        TileFarmPlain central = (TileFarmPlain)this.getCentralTE();
        if (central == null) {
            return null;
        }
        return central.getTankManager();
    }

    @Override
    public void getGUINetworkData(int messageId, int data) {
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
    }
}

