/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.core.vect.MutableVect;
import forestry.core.vect.Vect;
import forestry.core.vect.VectUtil;
import forestry.farming.gadgets.StructureLogicFarm;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmTarget {
    private final Vect start;
    private final ForgeDirection direction;
    private final int limit;
    private int yOffset;
    private int extent;

    public FarmTarget(Vect start, ForgeDirection direction, int limit) {
        this.start = start;
        this.direction = direction;
        this.limit = limit;
    }

    public Vect getStart() {
        return this.start;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public int getExtent() {
        return this.extent;
    }

    public ForgeDirection getDirection() {
        return this.direction;
    }

    public void setExtentAndYOffset(World world, Vect platformPosition) {
        if (platformPosition == null) {
            this.extent = 0;
            return;
        }
        MutableVect position = new MutableVect(platformPosition);
        this.extent = 0;
        while (this.extent < this.limit) {
            Block platform = VectUtil.getBlock(world, position);
            Vect soilPosition = new Vect(position.x, position.y + 1, position.z);
            if (!StructureLogicFarm.bricks.contains((Object)platform)) break;
            position.add(this.getDirection());
            ++this.extent;
        }
        this.yOffset = platformPosition.getY() + 1 - this.getStart().getY();
    }
}

