/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICarpenterManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.Defaults;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.IItemStackDisplay;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.items.ItemCrated;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.oredict.OreDictionary;

public class MachineCarpenter
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer,
IItemStackDisplay {
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_CRAFTING_COUNT = 9;
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_PRODUCT_COUNT = 1;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    public final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final TileInventoryAdapter craftingInventory;
    private final InventoryCraftResult craftPreviewInventory;
    @Nullable
    public Recipe currentRecipe;
    public Recipe lastRecipe;
    private int packageTime;
    private int totalTime;
    private ItemStack pendingProduct;

    public ItemStack getBoxStack() {
        return this.getInternalInventory().func_70301_a(9);
    }

    public MachineCarpenter() {
        super(1100, 50, 4000);
        this.setHints(Config.hints.get("carpenter"));
        this.resourceTank = new FilteredTank(10000, RecipeManager.recipeFluids);
        this.craftingInventory = new TileInventoryAdapter<MachineCarpenter>(this, 10, "CraftItems");
        this.craftPreviewInventory = new InventoryCraftResult();
        this.setInternalInventory(new CarpenterInventoryAdapter(this));
        InvTools.configureSided(this.getInternalInventory(), Defaults.FACINGS, 9, 21);
        this.tankManager = new TankManager(this.resourceTank);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.CarpenterGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("PackageTime", this.packageTime);
        nbttagcompound.func_74768_a("PackageTotalTime", this.totalTime);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
        if (this.pendingProduct != null) {
            NBTTagCompound nbttagcompoundP = new NBTTagCompound();
            this.pendingProduct.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("PendingProduct", (NBTBase)nbttagcompoundP);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.packageTime = nbttagcompound.func_74762_e("PackageTime");
        this.totalTime = nbttagcompound.func_74762_e("PackageTotalTime");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("PendingProduct")) {
            NBTTagCompound nbttagcompoundP = nbttagcompound.func_74775_l("PendingProduct");
            this.pendingProduct = ItemStack.func_77949_a((NBTTagCompound)nbttagcompoundP);
        }
        this.setCurrentRecipe(RecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory, this.field_145850_b));
    }

    public void resetRecipe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.setCurrentRecipe(RecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory, this.func_145831_w()));
    }

    private void setCurrentRecipe(@Nullable Recipe currentRecipe) {
        ItemStack craftingResult;
        this.currentRecipe = currentRecipe;
        if (currentRecipe != null) {
            this.lastRecipe = currentRecipe;
            craftingResult = currentRecipe.getCraftingResult();
        } else {
            craftingResult = null;
        }
        this.craftPreviewInventory.func_70299_a(0, craftingResult);
    }

    @Override
    public void updateServerSide() {
        Recipe recipe;
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        IInventoryAdapter accessibleInventory = this.getInternalInventory();
        if (accessibleInventory.func_70301_a(11) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)accessibleInventory, 11);
        }
        if (!this.updateOnInterval(40)) {
            return;
        }
        if (this.currentRecipe == null && (recipe = RecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory, this.field_145850_b)) != null) {
            this.setCurrentRecipe(recipe);
        }
        this.setErrorCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
        this.setErrorCondition(!this.validateResources(), EnumErrorCode.NORESOURCE);
    }

    @Override
    public boolean workCycle() {
        if (this.packageTime > 0) {
            --this.packageTime;
            if (this.currentRecipe == null || !this.validateResources()) {
                this.totalTime = 0;
                this.packageTime = 0;
                return false;
            }
            if (this.packageTime <= 0) {
                this.pendingProduct = this.currentRecipe.getCraftingResult();
                this.totalTime = 0;
                if (!this.removeResources(this.currentRecipe)) {
                    return false;
                }
                this.resetRecipe();
                return this.tryAddPending();
            }
            return true;
        }
        if (this.pendingProduct != null) {
            return this.tryAddPending();
        }
        if (this.currentRecipe != null) {
            if (!this.validateResources()) {
                return false;
            }
            this.packageTime = this.totalTime = this.currentRecipe.packagingTime;
            this.resetRecipe();
            return true;
        }
        return false;
    }

    private boolean validateResources() {
        ItemStack[] stock;
        if (this.currentRecipe == null) {
            return true;
        }
        if (this.currentRecipe.liquid != null && this.resourceTank.getFluidAmount() < ((Recipe)this.currentRecipe).liquid.amount) {
            return false;
        }
        IInventoryAdapter accessibleInventory = this.getInternalInventory();
        if (this.currentRecipe.box != null && accessibleInventory.func_70301_a(9) == null) {
            return false;
        }
        ItemStack[] set = InvTools.getStacks((IInventory)this.craftingInventory, 0, 9);
        return StackUtils.containsSets(set, stock = InvTools.getStacks((IInventory)accessibleInventory, 12, 18), true, false) > 0;
    }

    private boolean removeResources(Recipe recipe) {
        ItemStack removed;
        if (recipe.liquid != null) {
            FluidStack amountDrained = this.resourceTank.drain(((Recipe)recipe).liquid.amount, false);
            if (amountDrained != null && amountDrained.amount == ((Recipe)recipe).liquid.amount) {
                this.resourceTank.drain(((Recipe)recipe).liquid.amount, true);
            } else {
                return false;
            }
        }
        if (recipe.box != null && ((removed = this.getInternalInventory().func_70298_a(9, 1)) == null || removed.field_77994_a == 0)) {
            return false;
        }
        return this.removeSets(1, InvTools.getStacks((IInventory)this.craftingInventory, 0, 9));
    }

    private boolean removeSets(int count, ItemStack[] set) {
        EntityPlayer player = Proxies.common.getPlayer(this.field_145850_b, this.getOwner());
        return InvTools.removeSets((IInventory)this.getInternalInventory(), count, set, 12, 18, player, true, true, true);
    }

    private boolean tryAddPending() {
        if (this.pendingProduct == null) {
            return false;
        }
        boolean added = InvTools.tryAddStack((IInventory)this, this.pendingProduct, 10, 1, true);
        if (added) {
            this.pendingProduct = null;
        }
        this.setErrorCondition(!added, EnumErrorCode.NOSPACE);
        return added;
    }

    @Override
    public boolean isWorking() {
        return this.packageTime > 0 || this.pendingProduct != null || this.currentRecipe != null && this.validateResources();
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        IInventoryAdapter accessibleInventory = this.getInternalInventory();
        if (accessibleInventory.func_70301_a(10) != null && accessibleInventory.func_70301_a(10).func_77976_d() - accessibleInventory.func_70301_a((int)10).field_77994_a < this.currentRecipe.getCraftingResult().field_77994_a) {
            return false;
        }
        return this.validateResources();
    }

    public int getCraftingProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return (this.totalTime - this.packageTime) * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.packageTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.packageTime);
        iCrafting.func_71112_a(container, i + 1, this.totalTime);
    }

    public IInventory getCraftingInventory() {
        return this.craftingInventory;
    }

    public IInventory getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.func_70299_a(0, itemStack);
    }

    public int fill(ForgeDirection direction, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(direction, resource, doFill);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    public static class RecipeManager
    implements ICarpenterManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();
        private static final Set<Fluid> recipeFluids = new HashSet<Fluid>();
        private static final List<ItemStack> boxes = new ArrayList<ItemStack>();

        public void addCrating(ItemStack itemStack) {
            ItemStack uncrated = ((ItemCrated)itemStack.func_77973_b()).getContained();
            this.addRecipe(5, Fluids.WATER.getFluid(100), ForestryItem.crate.getItemStack(), itemStack, new Object[]{"###", "###", "###", Character.valueOf('#'), uncrated});
            this.addRecipe(null, new ItemStack(uncrated.func_77973_b(), 9, uncrated.func_77960_j()), new Object[]{"#", Character.valueOf('#'), itemStack});
        }

        public void addCratingWithOreDict(ItemStack itemStack) {
            int[] oreIds;
            ItemStack uncrated = ((ItemCrated)itemStack.func_77973_b()).getContained();
            for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)uncrated)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                this.addCrating(oreName, uncrated, itemStack);
            }
        }

        public void addCrating(String toCrate, ItemStack unpack, ItemStack crated) {
            this.addRecipe(5, Fluids.WATER.getFluid(100), ForestryItem.crate.getItemStack(), crated, new Object[]{"###", "###", "###", Character.valueOf('#'), toCrate});
            this.addRecipe(null, new ItemStack(unpack.func_77973_b(), 9, unpack.func_77960_j()), new Object[]{"#", Character.valueOf('#'), crated});
        }

        @Override
        public void addRecipe(ItemStack box, ItemStack product, Object[] materials) {
            this.addRecipe(5, (FluidStack)null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, ItemStack box, ItemStack product, Object[] materials) {
            this.addRecipe(packagingTime, (FluidStack)null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, FluidStack liquid, ItemStack box, ItemStack product, Object[] materials) {
            recipes.add(new Recipe(packagingTime, liquid, box, ShapedRecipeCustom.createShapedRecipe(product, materials)));
            if (liquid != null) {
                recipeFluids.add(liquid.getFluid());
            }
            if (box != null && !RecipeManager.isBox(box)) {
                boxes.add(box);
            }
        }

        public static Recipe findMatchingRecipe(FluidStack liquid, ItemStack item, IInventory inventorycrafting, World world) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(liquid, item, inventorycrafting, world)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isBox(ItemStack resource) {
            if (resource == null) {
                return false;
            }
            for (ItemStack box : boxes) {
                if (!StackUtils.isIdenticalItem(box, resource)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.internal.getIngredients(), new Object[]{recipe.getCraftingResult()});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        private final int packagingTime;
        private final FluidStack liquid;
        private final ItemStack box;
        private final ShapedRecipeCustom internal;

        public Recipe(int packagingTime, FluidStack liquid, ItemStack box, ShapedRecipeCustom internal) {
            this.packagingTime = packagingTime;
            this.liquid = liquid;
            this.box = box;
            this.internal = internal;
        }

        public ItemStack getCraftingResult() {
            return this.internal.func_77571_b();
        }

        public boolean matches(FluidStack resource, ItemStack item, IInventory inventorycrafting, World world) {
            if (!(this.liquid == null || resource != null && resource.containsFluid(this.liquid))) {
                return false;
            }
            if (this.box != null && !StackUtils.isCraftingEquivalent(this.box, item)) {
                return false;
            }
            return this.internal.matches(inventorycrafting, world);
        }

        public boolean isIngredient(ItemStack resource) {
            return this.internal.isIngredient(resource);
        }

        public ItemStack getBox() {
            return this.box;
        }

        public FluidStack getLiquid() {
            return this.liquid;
        }

        public IRecipe asIRecipe() {
            return this.internal;
        }
    }

    private static class CarpenterInventoryAdapter
    extends TileInventoryAdapter<MachineCarpenter> {
        public CarpenterInventoryAdapter(MachineCarpenter carpenter) {
            super(carpenter, 30, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 11) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((MachineCarpenter)this.tile).tankManager.accepts(fluid);
            }
            if (slotIndex == 9) {
                return RecipeManager.isBox(itemStack);
            }
            if (this.canSlotAccept(11, itemStack) || this.canSlotAccept(9, itemStack)) {
                return false;
            }
            return GuiUtil.isIndexInRange(slotIndex, 12, 18);
        }

        @Override
        public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
            if (GuiUtil.isIndexInRange(slotIndex, 12, 18) && ((MachineCarpenter)this.tile).lastRecipe != null) {
                return ((MachineCarpenter)this.tile).lastRecipe.isIngredient(itemStack);
            }
            return true;
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 10;
        }
    }
}

