/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.core.worldgen.BlockType;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class WorldGenBase
extends WorldGenerator {
    protected World world;
    protected Random rand;

    public final boolean func_76484_a(World world, Random random, int x, int y, int z) {
        return this.generate(world, random, x, y, z, false);
    }

    public final boolean generate(World world, Random random, int x, int y, int z, boolean forced) {
        this.world = world;
        this.rand = random;
        boolean result = this.subGenerate(x, y, z, forced);
        this.world = null;
        this.rand = null;
        return result;
    }

    public boolean subGenerate(int x, int y, int z, boolean forced) {
        return false;
    }

    protected abstract void addBlock(int var1, int var2, int var3, BlockType var4, EnumReplaceMode var5);

    protected final void generateCuboid(Vector start, Vector area, BlockType block, EnumReplaceMode replace) {
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    this.addBlock(x, y, z, block, replace);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCylinder(Vector center, float radius, int height, BlockType block, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center.x, y, center.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(x, y, z, block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCircle(Vector center, float radius, int width, int height, BlockType block, EnumReplaceMode replace) {
        this.generateCircle(center, radius, width, height, block, 1.0f, replace);
    }

    protected final void generateCircle(Vector center, float radius, int width, int height, BlockType block, float chance, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    double distance;
                    if (!(this.rand.nextFloat() > chance) && (double)(radius - (float)width) - 0.01 < (distance = Vector.distance(new Vector(x, y, z), new Vector(center.x, y, center.z))) && distance <= (double)radius + 0.01) {
                        this.addBlock(x, y, z, block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateSphere(Vector center, int radius, BlockType block, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - (float)radius, center.y - (float)radius, center.z - (float)radius);
        Vector area = new Vector(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center.x, center.y, center.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(x, y, z, block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static class Vector {
        public final float x;
        public final float y;
        public final float z;

        public Vector(float f, float h, float g) {
            this.x = f;
            this.y = h;
            this.z = g;
        }

        public static double distance(Vector a, Vector b) {
            return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
        }
    }

    protected static enum EnumReplaceMode {
        NONE,
        ALL,
        SOFT;

    }
}

