/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.gui.slots.SlotForestry;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.StackUtils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SlotHelper {
    private static final int playerInventorySize = 36;
    private static final int playerHotbarSize = 9;

    public static ItemStack slotClickPhantom(Slot slot, int mouseButton, int modifier, EntityPlayer player) {
        ItemStack stack = null;
        ItemStack stackSlot = slot.func_75211_c();
        if (stackSlot != null) {
            stack = stackSlot.func_77946_l();
        }
        if (mouseButton == 2) {
            SlotHelper.fillPhantomSlot(slot, null, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.field_71071_by;
            ItemStack stackHeld = playerInv.func_70445_o();
            if (stackSlot == null) {
                if (stackHeld != null && slot.func_75214_a(stackHeld)) {
                    SlotHelper.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld == null) {
                SlotHelper.adjustPhantomSlot(slot, mouseButton, modifier);
            } else if (slot.func_75214_a(stackHeld)) {
                if (StackUtils.isIdenticalItem(stackSlot, stackHeld)) {
                    SlotHelper.adjustPhantomSlot(slot, mouseButton, modifier);
                } else {
                    SlotHelper.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            }
        } else if (mouseButton == 5) {
            InventoryPlayer playerInv = player.field_71071_by;
            ItemStack stackHeld = playerInv.func_70445_o();
            if (!slot.func_75216_d()) {
                SlotHelper.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        }
        return stack;
    }

    public static ItemStack transferStackInSlot(List inventorySlots, EntityPlayer player, int slotIndex) {
        Slot slot = (Slot)inventorySlots.get(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        int numSlots = inventorySlots.size();
        ItemStack stackInSlot = slot.func_75211_c();
        ItemStack originalStack = stackInSlot.func_77946_l();
        if (!SlotHelper.shiftItemStack(inventorySlots, stackInSlot, slotIndex, numSlots)) {
            return null;
        }
        slot.func_75220_a(stackInSlot, originalStack);
        if (stackInSlot.field_77994_a <= 0) {
            slot.func_75215_d(null);
        } else {
            slot.func_75218_e();
        }
        if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
            return null;
        }
        slot.func_82870_a(player, stackInSlot);
        return originalStack;
    }

    private static boolean shiftItemStack(List inventorySlots, ItemStack stackInSlot, int slotIndex, int numSlots) {
        if (SlotHelper.isInPlayerInventory(slotIndex)) {
            if (SlotHelper.shiftToMachineInventory(inventorySlots, stackInSlot, numSlots)) {
                return true;
            }
            if (SlotHelper.isInPlayerHotbar(slotIndex)) {
                return SlotHelper.shiftToPlayerInventoryNoHotbar(inventorySlots, stackInSlot);
            }
            return SlotHelper.shiftToHotbar(inventorySlots, stackInSlot);
        }
        boolean shifted = SlotHelper.shiftToHotbar(inventorySlots, stackInSlot);
        if (!shifted) {
            shifted = SlotHelper.shiftToPlayerInventoryNoHotbar(inventorySlots, stackInSlot);
        }
        return shifted;
    }

    private static void adjustPhantomSlot(Slot slot, int mouseButton, int modifier) {
        int stackSize;
        if (!((SlotForestry)slot).canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        if (modifier == 1) {
            stackSize = mouseButton == 0 ? (stackSlot.field_77994_a + 1) / 2 : stackSlot.field_77994_a * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.field_77994_a - 1 : stackSlot.field_77994_a + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.field_77994_a = stackSize;
        if (stackSlot.field_77994_a <= 0) {
            stackSlot = null;
        }
        slot.func_75215_d(stackSlot);
    }

    private static void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (!((SlotForestry)slot).canAdjustPhantom()) {
            return;
        }
        if (stackHeld == null) {
            slot.func_75215_d(null);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.field_77994_a : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.field_77994_a = stackSize;
        slot.func_75215_d(phantomStack);
    }

    private static boolean shiftItemStackToRange(List inventorySlots, ItemStack stackToShift, int start, int count) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < start + count; ++slotIndex) {
                slot = (Slot)inventorySlots.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || !StackUtils.isIdenticalItem(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                if (resultingStackSize <= max) {
                    stackToShift.field_77994_a = 0;
                    stackInSlot.field_77994_a = resultingStackSize;
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.field_77994_a >= max) continue;
                stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
                stackInSlot.field_77994_a = max;
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.field_77994_a > 0) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < start + count; ++slotIndex) {
                slot = (Slot)inventorySlots.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
                stackToShift.field_77994_a -= stackInSlot.field_77994_a;
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    private static boolean isInPlayerInventory(int slotIndex) {
        return slotIndex < 36;
    }

    private static boolean isInPlayerHotbar(int slotIndex) {
        return GuiUtil.isIndexInRange(slotIndex, 27, 36);
    }

    private static boolean shiftToPlayerInventoryNoHotbar(List inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotHelper.shiftItemStackToRange(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToHotbar(List inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotHelper.shiftItemStackToRange(inventorySlots, stackInSlot, playerHotbarStart, 9);
    }

    private static boolean shiftToMachineInventory(List inventorySlots, ItemStack stackToShift, int numSlots) {
        boolean success = false;
        if (stackToShift.func_77985_e()) {
            success = SlotHelper.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, true);
        }
        if (stackToShift.field_77994_a > 0) {
            success |= SlotHelper.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, false);
        }
        return success;
    }

    private static boolean shiftToMachineInventory(List inventorySlots, ItemStack stackToShift, int numSlots, boolean mergeOnly) {
        for (int machineIndex = 36; machineIndex < numSlots; ++machineIndex) {
            SlotForestry slotForestry;
            Slot slot = (Slot)inventorySlots.get(machineIndex);
            if (mergeOnly && slot.func_75211_c() == null || slot instanceof SlotForestry && (!(slotForestry = (SlotForestry)slot).canShift() || slotForestry.isPhantom()) || !slot.func_75214_a(stackToShift) || !SlotHelper.shiftItemStackToRange(inventorySlots, stackToShift, machineIndex, 1)) continue;
            return true;
        }
        return false;
    }
}

