/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import com.mojang.authlib.GameProfile;
import forestry.apiculture.render.TextureHabitatLocator;
import forestry.core.ForestryClient;
import forestry.core.TickHandlerCoreClient;
import forestry.core.WorldGenerator;
import forestry.core.proxy.ClientProxyRender;
import forestry.core.proxy.Proxies;
import forestry.core.proxy.ProxyCommon;
import forestry.core.render.EntityHoneydustFX;
import forestry.core.render.SpriteSheet;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ClientProxyCommon
extends ProxyCommon {
    @Override
    public void bindTexture(ResourceLocation location) {
        this.getClientInstance().func_110434_K().func_110577_a(location);
    }

    @Override
    public void bindTexture(SpriteSheet spriteSheet) {
        this.bindTexture(spriteSheet.getLocation());
    }

    @Override
    public void registerTickHandlers(WorldGenerator worldGenerator) {
        super.registerTickHandlers(worldGenerator);
        new TickHandlerCoreClient();
    }

    @Override
    public IResourceManager getSelectedTexturePack(Minecraft minecraft) {
        return minecraft.func_110442_L();
    }

    @Override
    public void setHabitatLocatorCoordinates(Entity player, ChunkCoordinates coordinates) {
        TextureHabitatLocator.getInstance().setTargetCoordinates(coordinates);
    }

    @Override
    public File getForestryRoot() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public World getRenderWorld() {
        return this.getClientInstance().field_71441_e;
    }

    @Override
    public int getByBlockModelId() {
        return ForestryClient.byBlockModelId;
    }

    @Override
    public boolean isOp(EntityPlayer player) {
        return false;
    }

    @Override
    public double getBlockReachDistance(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityPlayerSP) {
            return this.getClientInstance().field_71442_b.func_78757_d();
        }
        return 4.0;
    }

    @Override
    public boolean isSimulating(World world) {
        return !world.field_72995_K;
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public String getItemStackDisplayName(Item item) {
        return item.func_77653_i(null);
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        return stack.func_77973_b().func_77653_i(stack);
    }

    @Override
    public String getCurrentLanguage() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
    }

    @Override
    public String getDisplayName(ItemStack itemstack) {
        return itemstack.func_77973_b().func_77653_i(itemstack);
    }

    @Override
    public void playSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.field_149762_H.func_150498_e(), block.field_149762_H.func_150497_c(), block.field_149762_H.func_150494_d());
        }
    }

    @Override
    public void playBlockBreakSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.field_149762_H.func_150495_a(), block.field_149762_H.func_150497_c() / 4.0f, block.field_149762_H.func_150494_d());
        }
    }

    @Override
    public void playBlockPlaceSoundFX(World world, int x, int y, int z, Block block) {
        if (Proxies.common.isSimulating(world)) {
            super.playSoundFX(world, x, y, z, block);
        } else {
            this.playSoundFX(world, x, y, z, block.field_149762_H.func_150498_e(), block.field_149762_H.func_150497_c() / 4.0f, block.field_149762_H.func_150494_d());
        }
    }

    @Override
    public void playSoundFX(World world, int x, int y, int z, String sound, float volume, float pitch) {
        world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, volume, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
    }

    @Override
    public void addEntityBiodustFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
    }

    @Override
    public void addEntitySwarmFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        this.getClientInstance().field_71452_i.func_78873_a((EntityFX)new EntityHoneydustFX(world, d1, d2, d3, f1, f2, f3));
    }

    @Override
    public void addEntityExplodeFX(World world, double d1, double d2, double d3, float f1, float f2, float f3) {
        if (!ClientProxyRender.shouldSpawnParticle(world)) {
            return;
        }
        this.getClientInstance().field_71452_i.func_78873_a((EntityFX)new EntityExplodeFX(world, d1, d2, d3, (double)f1, (double)f2, (double)f3));
    }

    @Override
    public void addBlockDestroyEffects(World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        if (!this.isSimulating(world)) {
            this.getClientInstance().field_71452_i.func_147215_a(xCoord, yCoord, zCoord, block, i);
        } else {
            super.addBlockDestroyEffects(world, xCoord, yCoord, zCoord, block, i);
        }
    }

    @Override
    public void addBlockPlaceEffects(World world, int xCoord, int yCoord, int zCoord, Block block, int i) {
        if (!this.isSimulating(world)) {
            this.playBlockPlaceSoundFX(world, xCoord, yCoord, zCoord, block);
        } else {
            super.addBlockPlaceEffects(world, xCoord, yCoord, zCoord, block, i);
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public EntityPlayer getPlayer(World world, GameProfile profile) {
        return super.getPlayer(world, profile);
    }
}

