/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IHintSource;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.Random;
import net.minecraft.client.gui.FontRenderer;

public class HintLedger
extends Ledger {
    private final String hintString;
    private final String hintTooltip;

    public HintLedger(LedgerManager manager, IHintSource tile) {
        super(manager, "hint");
        String[] hints = tile.getHints();
        int position = new Random().nextInt(hints.length);
        this.hintString = StringUtil.localize("hints." + hints[position] + ".desc");
        this.hintTooltip = StringUtil.localize("hints." + hints[position] + ".tag");
        FontRenderer fontRenderer = manager.minecraft.field_71466_p;
        int lineCount = fontRenderer.func_78271_c(this.hintString, 96).size();
        this.maxHeight = (lineCount + 1) * fontRenderer.field_78288_b + 20;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(TextureManager.getInstance().getDefault("misc/hint"), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(StringUtil.localize("gui.didyouknow") + '?', x + 22, y + 8);
        this.drawSplitText(this.hintString, x + 22, y + 20, 96);
    }

    @Override
    public String getTooltip() {
        return this.hintTooltip;
    }
}

