/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.common.Optional;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.utils.EnumTankLevel;
import forestry.energy.EnergyManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.tiles.IHasWork", modid="BuildCraftAPI|tiles")
public abstract class TilePowered
extends TileBase
implements IRenderableMachine,
IPowerHandler,
IHasWork {
    public static final int WORK_CYCLES = 4;
    protected final EnergyManager energyManager;
    private int workCounter;

    public TilePowered(int maxTransfer, int energyPerWork, int capacity) {
        this.energyManager = new EnergyManager(maxTransfer, energyPerWork, capacity);
        this.energyManager.setReceiveOnly();
    }

    public abstract boolean isWorking();

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public abstract boolean hasWork();

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        boolean disabled = this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) >= 15;
        this.setErrorCondition(disabled, EnumErrorCode.DISABLED);
        if (disabled) {
            return;
        }
        if (this.updateOnInterval(20)) {
            boolean hasEnergy = this.energyManager.hasEnergyToDoWork();
            this.setErrorCondition(!hasEnergy, EnumErrorCode.NOPOWER);
        }
        if (this.workCounter < 4) {
            if (this.energyManager.consumeEnergyToDoWork()) {
                ++this.workCounter;
            }
        } else if (this.updateOnInterval(5) && this.workCycle()) {
            this.workCounter = 0;
        }
    }

    public abstract boolean workCycle();

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energyManager.writeToNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyManager.readFromNBT(nbt);
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.extractEnergy(from, maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyManager.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyManager.getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }
}

