/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ErrorStateRegistry;
import forestry.api.core.IErrorState;
import forestry.core.config.Config;
import forestry.core.config.Defaults;
import forestry.core.fluids.TankManager;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IFilterSlotDelegate;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.interfaces.IRestrictedAccess;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketTileGuiOpened;
import forestry.core.network.PacketTileStream;
import forestry.core.proxy.Proxies;
import forestry.core.utils.AdjacentTileCache;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Utils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.statements.ITriggerProvider", modid="BuildCraftAPI|statements")
public abstract class TileForestry
extends TileEntity
implements IStreamable,
IRestrictedAccess,
IErrorSource,
ITriggerProvider,
ISidedInventory,
IFilterSlotDelegate {
    private static final Random rand = new Random();
    private IInventoryAdapter inventory = FakeInventoryAdapter.instance();
    private int tickCount = rand.nextInt(256);
    private boolean needsNetworkUpdate = false;
    private ForgeDirection orientation = ForgeDirection.WEST;
    protected final AdjacentTileCache tileCache = new AdjacentTileCache(this);
    protected boolean isInited = false;
    private final Set<IErrorState> errorStates = new HashSet<IErrorState>();
    private GameProfile owner = null;
    private EnumAccess access = EnumAccess.SHARED;

    public AdjacentTileCache getTileCache() {
        return this.tileCache;
    }

    public void onNeighborBlockChange(Block id) {
        this.tileCache.onNeighborChange();
    }

    public void func_145843_s() {
        this.tileCache.purge();
        super.func_145843_s();
    }

    public void func_145829_t() {
        this.tileCache.purge();
        super.func_145829_t();
    }

    public void openGui(EntityPlayer player) {
    }

    public void rotateAfterPlacement(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            this.setOrientation(ForgeDirection.NORTH);
        }
        if (l == 1) {
            this.setOrientation(ForgeDirection.EAST);
        }
        if (l == 2) {
            this.setOrientation(ForgeDirection.SOUTH);
        }
        if (l == 3) {
            this.setOrientation(ForgeDirection.WEST);
        }
    }

    public final void func_145845_h() {
        ++this.tickCount;
        if (!this.isInited) {
            this.initialize();
            this.isInited = true;
        }
        if (Proxies.common.isSimulating(this.field_145850_b)) {
            this.updateServerSide();
        } else {
            this.updateClientSide();
        }
        if (this.needsNetworkUpdate) {
            this.needsNetworkUpdate = false;
            this.sendNetworkUpdate();
        }
    }

    protected void updateClientSide() {
    }

    protected void updateServerSide() {
    }

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickCount % tickInterval == 0;
    }

    public abstract void initialize();

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventory.readFromNBT(data);
        this.access = data.func_74764_b("Access") ? EnumAccess.values()[data.func_74762_e("Access")] : EnumAccess.SHARED;
        if (data.func_74764_b("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)data.func_74775_l("owner"));
        }
        this.orientation = data.func_74764_b("Orientation") ? ForgeDirection.values()[data.func_74762_e("Orientation")] : ForgeDirection.WEST;
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.inventory.writeToNBT(data);
        data.func_74768_a("Access", this.access.ordinal());
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            data.func_74782_a("owner", (NBTBase)nbt);
        }
        if (this.orientation != null) {
            data.func_74768_a("Orientation", this.orientation.ordinal());
        }
    }

    public final Packet func_145844_m() {
        PacketTileStream packet = new PacketTileStream(this);
        return packet.getPacket();
    }

    public final void sendNetworkUpdate() {
        PacketTileStream packet = new PacketTileStream(this);
        Proxies.net.sendNetworkPacket(packet);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        TankManager tankManager;
        data.writeByte(this.orientation.ordinal());
        if (this instanceof ILiquidTankContainer && (tankManager = ((ILiquidTankContainer)((Object)this)).getTankManager()) != null) {
            tankManager.writePacketData(data);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        TankManager tankManager;
        this.orientation = ForgeDirection.getOrientation((int)data.readByte());
        if (this instanceof ILiquidTankContainer && (tankManager = ((ILiquidTankContainer)((Object)this)).getTankManager()) != null) {
            tankManager.readPacketData(data);
        }
    }

    public final void writeErrorData(DataOutputStreamForestry data) throws IOException {
        data.writeShort(this.errorStates.size());
        for (IErrorState errorState : this.errorStates) {
            data.writeShort(errorState.getID());
        }
    }

    public final void readErrorData(DataInputStreamForestry data) throws IOException {
        this.errorStates.clear();
        int errorStateCount = data.readShort();
        for (int i = 0; i < errorStateCount; ++i) {
            short errorStateId = data.readShort();
            IErrorState errorState = ErrorStateRegistry.getErrorState(errorStateId);
            this.errorStates.add(errorState);
        }
    }

    public final void sendGuiOpened(EntityPlayer player) {
        PacketTileGuiOpened packet = new PacketTileGuiOpened(this);
        Proxies.net.sendToPlayer(packet, player);
    }

    public final void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.writeErrorData(data);
        if (this.owner == null) {
            data.writeByte(-1);
        } else {
            data.writeByte(this.access.ordinal());
            data.writeLong(this.owner.getId().getMostSignificantBits());
            data.writeLong(this.owner.getId().getLeastSignificantBits());
            data.writeUTF(this.owner.getName());
        }
    }

    public final void readGuiData(DataInputStreamForestry data) throws IOException {
        this.readErrorData(data);
        byte accessOrdinal = data.readByte();
        if (accessOrdinal >= 0) {
            this.access = EnumAccess.values()[accessOrdinal];
            this.owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.readUTF());
        }
    }

    public void onRemoval() {
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        return null;
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        return null;
    }

    public boolean isRedstoneActivated() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.setNeedsNetworkUpdate();
    }

    protected final void setNeedsNetworkUpdate() {
        this.needsNetworkUpdate = true;
    }

    public final boolean setErrorCondition(boolean condition, IErrorState errorState) {
        if (condition) {
            this.errorStates.add(errorState);
        } else {
            this.errorStates.remove(errorState);
        }
        return condition;
    }

    @Deprecated
    protected final void addErrorState(IErrorState state) {
        this.errorStates.add(state);
    }

    @Deprecated
    protected final void removeErrorStates() {
        this.errorStates.clear();
    }

    public final boolean hasErrorState(IErrorState state) {
        return this.errorStates.contains(state);
    }

    public final boolean hasErrorState() {
        return this.errorStates.size() > 0;
    }

    @Override
    public ImmutableSet<IErrorState> getErrorStates() {
        return ImmutableSet.copyOf(this.errorStates);
    }

    @Override
    public final boolean allowsRemoval(EntityPlayer player) {
        return Config.disablePermissions || this.getAccess() == EnumAccess.SHARED || !this.isOwned() || this.isOwner(player) || Proxies.common.isOp(player);
    }

    @Override
    public final boolean allowsAlteration(EntityPlayer player) {
        return this.allowsRemoval(player);
    }

    @Override
    public final boolean allowsViewing(EntityPlayer player) {
        return this.allowsAlteration(player) || this.getAccess() == EnumAccess.VIEWABLE;
    }

    private boolean allowsPipeConnections() {
        return this.access == EnumAccess.SHARED;
    }

    @Override
    public EnumAccess getAccess() {
        return this.access;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player.func_146103_bH();
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        if (this.owner != null && player != null) {
            return PlayerUtil.isSameGameProfile(this.owner, player.func_146103_bH());
        }
        return false;
    }

    @Override
    public boolean switchAccessRule(EntityPlayer player) {
        if (!this.isOwner(player)) {
            return false;
        }
        boolean couldPipesConnect = this.allowsPipeConnections();
        int ordinal = (this.access.ordinal() + 1) % EnumAccess.values().length;
        this.access = EnumAccess.values()[ordinal];
        if (!this.field_145850_b.field_72995_K) {
            this.sendGuiOpened(player);
            boolean canPipesConnect = this.allowsPipeConnections();
            if (couldPipesConnect != canPipesConnect) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
                this.func_70296_d();
            }
        }
        return true;
    }

    public String getUnlocalizedName() {
        String blockUnlocalizedName = this.func_145838_q().func_149739_a().replace("tile.for.", "");
        return blockUnlocalizedName + '.' + this.func_145832_p() + ".name";
    }

    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    public final void setInternalInventory(IInventoryAdapter inv) {
        if (inv == null) {
            throw new NullPointerException("Inventory cannot be null");
        }
        this.inventory = inv;
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public final ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_70295_k_() {
        this.getInternalInventory().func_70295_k_();
    }

    public final void func_70305_f() {
        this.getInternalInventory().func_70305_f();
    }

    public final String func_145825_b() {
        return this.getUnlocalizedName();
    }

    public final boolean func_70300_a(EntityPlayer player) {
        if (!Utils.isUseableByPlayer(player, this) || !this.allowsViewing(player)) {
            return false;
        }
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (itemStack == null || !this.allowsPipeConnections()) {
            return false;
        }
        if (!this.canSlotAccept(slotIndex, itemStack)) {
            return false;
        }
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    public final int[] func_94128_d(int side) {
        if (!this.allowsPipeConnections()) {
            return Defaults.SLOTS_NONE;
        }
        return this.getInternalInventory().func_94128_d(side);
    }

    public final boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        if (itemStack == null || !this.allowsPipeConnections()) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public final boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        if (itemStack == null || !this.allowsPipeConnections()) {
            return false;
        }
        return this.getInternalInventory().func_102008_b(slotIndex, itemStack, side);
    }
}

