/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.IItemStackDisplay;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.PacketItemStackDisplay;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.GuiUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileAnalyzer
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer,
IItemStackDisplay {
    public static final int TIME_TO_ANALYZE = 125;
    public static final int HONEY_REQUIRED = 100;
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_INPUT_COUNT = 6;
    public static final short SLOT_OUTPUT_1 = 8;
    public static final short SLOT_OUTPUT_COUNT = 4;
    private int analyzeTime;
    public final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final IInventory invInput;
    private final IInventory invOutput;
    private ItemStack individualOnDisplayClient;

    public TileAnalyzer() {
        super(800, 40, 5000);
        this.setInternalInventory(new AnalyzerInventoryAdapter(this));
        this.resourceTank = new FilteredTank(10000, Fluids.HONEY.getFluid());
        this.tankManager = new TankManager(this.resourceTank);
        this.invInput = new InventoryMapper((IInventory)this.getInternalInventory(), 2, 6);
        this.invOutput = new InventoryMapper((IInventory)this.getInternalInventory(), 8, 4);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.AnalyzerGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("AnalyzeTime", this.analyzeTime);
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.analyzeTime = nbttagcompound.func_74762_e("AnalyzeTime");
        this.tankManager.readTanksFromNBT(nbttagcompound);
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 1);
        }
    }

    @Override
    public boolean workCycle() {
        IIndividual individual;
        ItemStack stackToAnalyze = this.func_70301_a(0);
        if (stackToAnalyze != null) {
            boolean added;
            IIndividual individual2 = AlleleManager.alleleRegistry.getIndividual(stackToAnalyze);
            if (individual2 == null) {
                return false;
            }
            if (this.analyzeTime > 0) {
                --this.analyzeTime;
                return true;
            }
            if (!individual2.isAnalyzed()) {
                individual2.analyze();
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                individual2.writeToNBT(nbttagcompound);
                stackToAnalyze.func_77982_d(nbttagcompound);
            }
            if (added = InvTools.tryAddStack(this.invOutput, stackToAnalyze, true)) {
                this.func_70299_a(0, null);
                PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
                Proxies.net.sendNetworkPacket(packet);
            }
            this.setErrorCondition(!added, EnumErrorCode.NOSPACE);
            return added;
        }
        IInvSlot slot = this.getInputSlot();
        boolean noInput = slot == null;
        this.setErrorCondition(noInput, EnumErrorCode.NOTHINGANALYZE);
        if (noInput) {
            return false;
        }
        ItemStack inputStack = slot.getStackInSlot();
        ItemStack ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(inputStack);
        if (ersatz != null) {
            inputStack = ersatz;
        }
        if (!(individual = AlleleManager.alleleRegistry.getIndividual(inputStack)).isAnalyzed()) {
            boolean hasHoney = this.resourceTank.getFluidAmount() >= 100;
            this.setErrorCondition(!hasHoney, EnumErrorCode.NORESOURCE);
            if (!hasHoney) {
                return false;
            }
            this.resourceTank.drain(100, true);
            this.analyzeTime = 125;
        }
        this.func_70299_a(0, inputStack);
        slot.setStackInSlot(null);
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        Proxies.net.sendNetworkPacket(packet);
        return true;
    }

    private IInvSlot getInputSlot() {
        for (IInvSlot slot : InventoryIterator.getIterable(this.invInput)) {
            ItemStack inputStack = slot.getStackInSlot();
            if (inputStack == null || !AlleleManager.alleleRegistry.isIndividual(inputStack) && GeneticsUtil.getGeneticEquivalent(inputStack) == null) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        ItemStack displayStack = this.getIndividualOnDisplay();
        data.writeItemStack(displayStack);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.individualOnDisplayClient = data.readItemStack();
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)this.individualOnDisplayClient)) {
            this.individualOnDisplayClient = itemStack;
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean isWorking() {
        return this.analyzeTime > 0;
    }

    @Override
    public boolean hasWork() {
        HashSet<IErrorState> errors = new HashSet<IErrorState>((Collection<IErrorState>)this.getErrorStates());
        errors.remove(EnumErrorCode.NOPOWER);
        return errors.size() == 0;
    }

    public int getProgressScaled(int i) {
        return this.analyzeTime * i / 125;
    }

    public ItemStack getIndividualOnDisplay() {
        if (this.field_145850_b.field_72995_K) {
            return this.individualOnDisplayClient;
        }
        return this.func_70301_a(0);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.analyzeTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.analyzeTime);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class AnalyzerInventoryAdapter
    extends TileInventoryAdapter<TileAnalyzer> {
        public AnalyzerInventoryAdapter(TileAnalyzer analyzer) {
            super(analyzer, 12, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (GuiUtil.isIndexInRange(slotIndex, 2, 6)) {
                return AlleleManager.alleleRegistry.isIndividual(itemStack) || GeneticsUtil.getGeneticEquivalent(itemStack) != null;
            }
            if (slotIndex == 1) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((TileAnalyzer)this.tile).resourceTank.accepts(fluid);
            }
            return false;
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack stack, int side) {
            return GuiUtil.isIndexInRange(slotIndex, 8, 4);
        }
    }
}

