/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.WorldGenMinableMeta;
import forestry.plugins.PluginManager;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class WorldGenerator
implements IWorldGenerator {
    private WorldGenMinableMeta apatiteGenerator;
    private WorldGenMinableMeta copperGenerator;
    private WorldGenMinableMeta tinGenerator;

    public WorldGenerator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world);
    }

    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Post event) {
        PluginManager.populateChunk(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ, event.hasVillageGenerated);
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateWorld(random, chunkX, chunkZ, world);
        PluginManager.populateChunkRetroGen(world, random, chunkX, chunkZ);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    private void generateWorld(Random random, int chunkX, int chunkZ, World world) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int i;
        if (this.apatiteGenerator == null) {
            this.apatiteGenerator = new WorldGenMinableMeta(ForestryBlock.resources, 0, 36);
            this.copperGenerator = new WorldGenMinableMeta(ForestryBlock.resources, 1, 6);
            this.tinGenerator = new WorldGenMinableMeta(ForestryBlock.resources, 2, 6);
        }
        chunkX <<= 4;
        chunkZ <<= 4;
        if (Config.generateApatiteOre && random.nextFloat() < 0.8f) {
            int randPosX2 = chunkX + random.nextInt(16);
            int randPosY2 = random.nextInt(world.func_72940_L() - 72) + 56;
            int randPosZ2 = chunkZ + random.nextInt(16);
            this.apatiteGenerator.func_76484_a(world, random, randPosX2, randPosY2, randPosZ2);
        }
        if (Config.generateCopperOre) {
            for (i = 0; i < 20; ++i) {
                randPosX = chunkX + random.nextInt(16);
                randPosY = random.nextInt(76) + 32;
                randPosZ = chunkZ + random.nextInt(16);
                this.copperGenerator.func_76484_a(world, random, randPosX, randPosY, randPosZ);
            }
        }
        if (Config.generateTinOre) {
            for (i = 0; i < 18; ++i) {
                randPosX = chunkX + random.nextInt(16);
                randPosY = random.nextInt(76) + 16;
                randPosZ = chunkZ + random.nextInt(16);
                this.tinGenerator.func_76484_a(world, random, randPosX, randPosY, randPosZ);
            }
        }
    }
}

