/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.ITree;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.core.config.Config;
import forestry.core.interfaces.IHintSource;
import forestry.core.inventory.AlyzerInventory;
import forestry.core.items.ItemInventoried;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GeneticsUtil;
import forestry.plugins.PluginArboriculture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemTreealyzer
extends ItemInventoried {
    public ItemTreealyzer() {
        this.func_77625_d(1);
        this.func_77637_a(Tabs.tabArboriculture);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.TreealyzerGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class TreealyzerInventory
    extends AlyzerInventory
    implements IHintSource {
        public TreealyzerInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 7, itemStack);
        }

        @Override
        protected boolean isSpecimen(ItemStack itemStack) {
            return GeneticsUtil.getGeneticEquivalent(itemStack) instanceof ITree;
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            ITree tree;
            ItemStack ersatz;
            if (this.func_70301_a(0) == null) {
                return;
            }
            if (!PluginArboriculture.treeInterface.isMember(this.func_70301_a(0)) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(this.func_70301_a(0))) != null) {
                this.func_70299_a(0, ersatz);
            }
            if ((tree = PluginArboriculture.treeInterface.getMember(this.func_70301_a(0))) == null) {
                return;
            }
            if (!tree.isAnalyzed()) {
                if (!TreealyzerInventory.isEnergy(this.func_70301_a(5))) {
                    return;
                }
                tree.analyze();
                if (player != null) {
                    PluginArboriculture.treeInterface.getBreedingTracker(player.field_70170_p, player.func_146103_bH()).registerSpecies(tree.getGenome().getPrimary());
                    PluginArboriculture.treeInterface.getBreedingTracker(player.field_70170_p, player.func_146103_bH()).registerSpecies(tree.getGenome().getSecondary());
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                tree.writeToNBT(nbttagcompound);
                this.func_70301_a(0).func_77982_d(nbttagcompound);
                this.func_70298_a(5, 1);
            }
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("treealyzer") != null && Config.hints.get("treealyzer").length > 0;
        }

        @Override
        public String[] getHints() {
            return Config.hints.get("treealyzer");
        }
    }
}

