/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.genetics.Tree;
import forestry.core.interfaces.IOwnable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.utils.PlayerUtil;
import forestry.plugins.PluginArboriculture;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public abstract class TileTreeContainer
extends TileEntity
implements IStreamable,
IOwnable {
    private ITree containedTree;
    public GameProfile owner = null;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ContainedTree")) {
            this.containedTree = new Tree(nbttagcompound.func_74775_l("ContainedTree"));
        }
        if (nbttagcompound.func_74764_b("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("owner"));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.containedTree != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.containedTree.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("ContainedTree", (NBTBase)subcompound);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        String speciesUID = "";
        ITree tree = this.getTree();
        if (tree != null) {
            speciesUID = tree.getIdent();
        }
        data.writeUTF(speciesUID);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        String speciesUID = data.readUTF();
        ITree tree = TileTreeContainer.getTree(speciesUID);
        this.setTree(tree);
    }

    public static ITree getTree(String speciesUID) {
        IAllele[] treeTemplate = PluginArboriculture.treeInterface.getTemplate(speciesUID);
        if (treeTemplate == null) {
            return null;
        }
        return PluginArboriculture.treeInterface.templateAsIndividual(treeTemplate);
    }

    public void setTree(ITree tree) {
        this.containedTree = tree;
    }

    public ITree getTree() {
        return this.containedTree;
    }

    public boolean canUpdate() {
        return false;
    }

    public abstract void onBlockTick();

    public abstract Packet func_145844_m();

    @Override
    public boolean allowsRemoval(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player.func_146103_bH();
    }

    public void setOwner(GameProfile playername) {
        this.owner = playername;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return PlayerUtil.isSameGameProfile(this.owner, player.func_146103_bH());
    }
}

