/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.apiculture.genetics.Bee;
import forestry.core.inventory.ItemInventory;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemImprinter
extends ItemForestry {
    public ItemImprinter() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.ImprinterGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static class ImprinterInventory
    extends ItemInventory {
        private static final short specimenSlot = 0;
        private static final short imprintedSlot = 1;
        private int primaryIndex = 0;
        private int secondaryIndex = 0;

        public ImprinterInventory(EntityPlayer player, ItemStack itemStack) {
            super(player, 2, itemStack);
        }

        public void advancePrimary() {
            this.primaryIndex = this.primaryIndex < BeeManager.beeRoot.getIndividualTemplates().size() - 1 ? ++this.primaryIndex : 0;
        }

        public void advanceSecondary() {
            this.secondaryIndex = this.secondaryIndex < BeeManager.beeRoot.getIndividualTemplates().size() - 1 ? ++this.secondaryIndex : 0;
        }

        public void regressPrimary() {
            this.primaryIndex = this.primaryIndex > 0 ? --this.primaryIndex : BeeManager.beeRoot.getIndividualTemplates().size() - 1;
        }

        public void regressSecondary() {
            this.secondaryIndex = this.secondaryIndex > 0 ? --this.secondaryIndex : BeeManager.beeRoot.getIndividualTemplates().size() - 1;
        }

        public IAlleleBeeSpecies getPrimary() {
            return BeeManager.beeRoot.getIndividualTemplates().get(this.primaryIndex).getGenome().getPrimary();
        }

        public IAlleleBeeSpecies getSecondary() {
            return BeeManager.beeRoot.getIndividualTemplates().get(this.secondaryIndex).getGenome().getPrimary();
        }

        public IBee getSelectedBee() {
            return new Bee(BeeManager.beeRoot.templateAsGenome(BeeManager.beeRoot.getGenomeTemplates().get(BeeManager.beeRoot.getIndividualTemplates().get(this.primaryIndex).getIdent()), BeeManager.beeRoot.getGenomeTemplates().get(BeeManager.beeRoot.getIndividualTemplates().get(this.secondaryIndex).getIdent())));
        }

        public int getPrimaryIndex() {
            return this.primaryIndex;
        }

        public int getSecondaryIndex() {
            return this.secondaryIndex;
        }

        public void setPrimaryIndex(int index) {
            this.primaryIndex = index;
        }

        public void setSecondaryIndex(int index) {
            this.secondaryIndex = index;
        }

        @Override
        public void onSlotClick(EntityPlayer player) {
            ItemStack specimen = this.func_70301_a(0);
            if (specimen == null) {
                return;
            }
            if (!BeeManager.beeRoot.isMember(specimen)) {
                return;
            }
            if (this.func_70301_a(1) != null) {
                return;
            }
            IBee imprint = this.getSelectedBee();
            if (imprint == null) {
                return;
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            imprint.writeToNBT(nbttagcompound);
            specimen.func_77982_d(nbttagcompound);
            this.func_70299_a(1, specimen);
            this.func_70299_a(0, null);
        }

        @Override
        public String func_145825_b() {
            return "Imprinter";
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return BeeManager.beeRoot.isMember(itemStack);
        }
    }
}

