/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.core.genetics.Mutation;
import net.minecraft.world.World;

public class BeeMutation
extends Mutation
implements IBeeMutationCustom {
    public BeeMutation(IAlleleBeeSpecies bee0, IAlleleBeeSpecies bee1, IAllele[] result, int chance) {
        super(bee0, bee1, result, chance);
    }

    @Override
    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    @Override
    public float getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        return this.getChance(housing, (IAlleleBeeSpecies)allele0, (IAlleleBeeSpecies)allele1, (IBeeGenome)genome0, (IBeeGenome)genome1);
    }

    @Override
    public float getChance(IBeeHousing housing, IAlleleBeeSpecies allele0, IAlleleBeeSpecies allele1, IBeeGenome genome0, IBeeGenome genome1) {
        int z;
        int y;
        int x;
        World world = housing.getWorld();
        float processedChance = super.getChance(world, x = housing.getXCoord(), y = housing.getYCoord(), z = housing.getZCoord(), allele0, allele1, genome0, genome1);
        if (processedChance <= 0.0f) {
            return 0.0f;
        }
        processedChance *= housing.getMutationModifier(genome0, genome1, 1.0f);
        if ((processedChance *= BeeManager.beeRoot.getBeekeepingMode(world).getMutationModifier(genome0, genome1, 1.0f)) <= 0.0f) {
            return 0.0f;
        }
        if (this.species0.getUID().equals(allele0.getUID()) && this.species1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.species1.getUID().equals(allele0.getUID()) && this.species0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }
}

