/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.plugins.PluginApiculture;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class AlleleEffectIgnition
extends AlleleEffectThrottled {
    private static final int ignitionChance = 50;
    private static final int fireDuration = 500;

    public AlleleEffectIgnition() {
        super("ignition", false, 20, false, true);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        AxisAlignedBB hurtBox = this.getBounding(genome, housing, 1.0f);
        List list = world.func_72872_a(EntityLivingBase.class, hurtBox);
        for (Object obj : list) {
            EntityLivingBase entity = (EntityLivingBase)obj;
            int chance = 50;
            int duration = 500;
            if (entity instanceof EntityPlayer) {
                int count = ItemArmorApiarist.wearsItems((EntityPlayer)entity, this.getUID(), true);
                if (count > 3) continue;
                if (count > 2) {
                    chance = 5;
                    duration = 50;
                } else if (count > 1) {
                    chance = 20;
                    duration = 200;
                } else if (count > 0) {
                    chance = 35;
                    duration = 350;
                }
            }
            if (world.field_73012_v.nextInt(1000) >= chance) continue;
            entity.func_70015_d(duration);
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = this.getModifiedArea(genome, housing);
        if (housing.getWorld().field_73012_v.nextBoolean()) {
            PluginApiculture.proxy.addBeeHiveFX("particles/swarm_bee", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimary().getIconColour(0), area[0], area[1], area[2]);
        } else {
            PluginApiculture.proxy.addBeeHiveFX("particles/ember", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), 0xFFFFFF, area[0], area[1], area[2]);
        }
        return storedData;
    }
}

