/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class AlleleEffectFertile
extends AlleleEffectThrottled {
    public static final int MAX_BLOCK_FIND_TRIES = 5;

    public AlleleEffectFertile() {
        super("fertile", false, 6, true, false);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        World world = housing.getWorld();
        int[] territorySize = this.getModifiedArea(genome, housing);
        int blockX = this.getRandomOffset(world.field_73012_v, housing.getXCoord(), territorySize[0]);
        int blockZ = this.getRandomOffset(world.field_73012_v, housing.getZCoord(), territorySize[2]);
        int blockMaxY = housing.getYCoord() + territorySize[1] / 2 + 1;
        int blockMinY = housing.getYCoord() - territorySize[1] / 2 - 1;
        for (int attempt = 0; attempt < 5 && !this.tryTickColumn(world, blockX, blockZ, blockMaxY, blockMinY); ++attempt) {
            blockX = this.getRandomOffset(world.field_73012_v, housing.getXCoord(), territorySize[0]);
            blockZ = this.getRandomOffset(world.field_73012_v, housing.getZCoord(), territorySize[2]);
        }
        return storedData;
    }

    private int getRandomOffset(Random random, int centrePos, int offset) {
        return centrePos + random.nextInt(offset) - offset / 2;
    }

    private boolean tryTickColumn(World world, int x, int z, int maxY, int minY) {
        for (int y = maxY; y >= minY; --y) {
            if (world.func_147437_c(x, y, z)) continue;
            Block block = world.func_147439_a(x, y, z);
            world.func_147464_a(x, y, z, block, 5);
            return true;
        }
        return false;
    }
}

