/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpeciesCustom;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeIconProvider;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.JubilanceDefault;
import forestry.core.genetics.alleles.AlleleSpecies;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class AlleleBeeSpecies
extends AlleleSpecies
implements IAlleleBeeSpeciesCustom {
    @Deprecated
    private final Map<ItemStack, Integer> products = new HashMap<ItemStack, Integer>();
    @Deprecated
    private final Map<ItemStack, Integer> specialty = new HashMap<ItemStack, Integer>();
    private final Map<ItemStack, Float> productChances = new HashMap<ItemStack, Float>();
    private final Map<ItemStack, Float> specialtyChances = new HashMap<ItemStack, Float>();
    private final int primaryColour;
    private final int secondaryColour;
    private IBeeIconProvider beeIconProvider;
    private IJubilanceProvider jubilanceProvider;
    private boolean nocturnal = false;

    public AlleleBeeSpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean dominant, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        super(uid, unlocalizedName, authority, unlocalizedDescription, dominant, branch, binomial, false);
        this.primaryColour = primaryColor;
        this.secondaryColour = secondaryColor;
        this.setCustomBeeIconProvider(DefaultBeeIconProvider.getInstance());
        this.setJubilanceProvider(JubilanceDefault.getInstance());
    }

    @Override
    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    @Override
    public IAlleleBeeSpeciesCustom addProduct(ItemStack product, Float chance) {
        if (product == null || product.func_77973_b() == null) {
            throw new IllegalArgumentException("Tried to add null product");
        }
        if (chance.floatValue() <= 0.0f || chance.floatValue() > 1.0f) {
            throw new IllegalArgumentException("chance must be in the range (0, 1]");
        }
        this.productChances.put(product, chance);
        int intChance = Math.max(1, Math.round(chance.floatValue() * 100.0f));
        this.products.put(product, intChance);
        return this;
    }

    @Override
    public IAlleleBeeSpeciesCustom addSpecialty(ItemStack specialty, Float chance) {
        if (specialty == null || specialty.func_77973_b() == null) {
            throw new IllegalArgumentException("Tried to add null specialty");
        }
        if (chance.floatValue() <= 0.0f || chance.floatValue() > 1.0f) {
            throw new IllegalArgumentException("chance must be in the range (0, 1]");
        }
        this.specialtyChances.put(specialty, chance);
        int intChance = Math.max(1, Math.round(chance.floatValue() * 100.0f));
        this.specialty.put(specialty, intChance);
        return this;
    }

    @Override
    public IAlleleBeeSpeciesCustom setJubilanceProvider(IJubilanceProvider provider) {
        this.jubilanceProvider = provider;
        return this;
    }

    @Override
    public IAlleleBeeSpeciesCustom setNocturnal() {
        this.nocturnal = true;
        return this;
    }

    @Override
    public IAlleleBeeSpeciesCustom setCustomBeeIconProvider(IBeeIconProvider beeIconProvider) {
        this.beeIconProvider = beeIconProvider;
        return this;
    }

    @Override
    public int getComplexity() {
        return 1 + this.getGeneticAdvancement(this, new ArrayList<IAllele>());
    }

    private int getGeneticAdvancement(IAllele species, ArrayList<IAllele> exclude) {
        int own = 1;
        int highest = 0;
        exclude.add(species);
        for (IMutation iMutation : this.getRoot().getPaths(species, EnumBeeChromosome.SPECIES)) {
            int otherAdvance;
            if (!exclude.contains(iMutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement(iMutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(iMutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement(iMutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest < 0 ? 0 : highest);
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        for (ItemStack stack : this.productChances.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack stack : this.specialtyChances.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(itemstack);
    }

    @Override
    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        Collections.addAll(bounty, super.getResearchBounty(world, researcher, individual, bountyLevel));
        if (bountyLevel > 10) {
            for (ItemStack stack : this.specialtyChances.keySet()) {
                bounty.add(StackUtils.copyWithRandomSize(stack, (int)((float)bountyLevel / 2.0f), world.field_73012_v));
            }
        }
        for (ItemStack stack : this.productChances.keySet()) {
            bounty.add(StackUtils.copyWithRandomSize(stack, (int)((float)bountyLevel / 2.0f), world.field_73012_v));
        }
        return bounty.toArray(new ItemStack[bounty.size()]);
    }

    @Override
    public boolean isNocturnal() {
        return this.nocturnal;
    }

    @Override
    public Map<ItemStack, Integer> getProducts() {
        return this.products;
    }

    @Override
    public Map<ItemStack, Float> getProductChances() {
        return this.productChances;
    }

    @Override
    public Map<ItemStack, Integer> getSpecialty() {
        return this.specialty;
    }

    @Override
    public Map<ItemStack, Float> getSpecialtyChances() {
        return this.specialtyChances;
    }

    @Override
    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return this.jubilanceProvider.isJubilant(this, genome, housing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return new BeeIconProviderWrapper(this.beeIconProvider);
    }

    @Override
    public IIcon getIcon(EnumBeeType type, int renderPass) {
        return this.beeIconProvider.getIcon(type, renderPass);
    }

    @Override
    public int getIconColour(int renderPass) {
        if (renderPass == 0) {
            return this.primaryColour;
        }
        if (renderPass == 1) {
            return this.secondaryColour;
        }
        return 0xFFFFFF;
    }

    @Override
    public String getEntityTexture() {
        return null;
    }

    private static class BeeIconProviderWrapper
    implements IIconProvider {
        private final IBeeIconProvider beeIconProvider;

        public BeeIconProviderWrapper(IBeeIconProvider beeIconProvider) {
            this.beeIconProvider = beeIconProvider;
        }

        @Override
        public IIcon getIcon(short texUID) {
            return null;
        }

        @Override
        public void registerIcons(IIconRegister register) {
            this.beeIconProvider.registerIcons(register);
        }
    }

    private static class DefaultBeeIconProvider
    implements IBeeIconProvider {
        private static final String iconType = "default";
        private static DefaultBeeIconProvider instance;
        private static final IIcon[][] icons;

        public static DefaultBeeIconProvider getInstance() {
            if (instance == null) {
                instance = new DefaultBeeIconProvider();
            }
            return instance;
        }

        private DefaultBeeIconProvider() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerIcons(IIconRegister register) {
            IIcon body1 = TextureManager.getInstance().registerTex(register, "bees/default/body1");
            for (int i = 0; i < EnumBeeType.values().length; ++i) {
                if (EnumBeeType.values()[i] == EnumBeeType.NONE) continue;
                DefaultBeeIconProvider.icons[i][0] = TextureManager.getInstance().registerTex(register, "bees/default/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".outline");
                DefaultBeeIconProvider.icons[i][1] = EnumBeeType.values()[i] != EnumBeeType.LARVAE ? body1 : TextureManager.getInstance().registerTex(register, "bees/default/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body");
                DefaultBeeIconProvider.icons[i][2] = TextureManager.getInstance().registerTex(register, "bees/default/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body2");
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon(EnumBeeType type, int renderPass) {
            return icons[type.ordinal()][renderPass];
        }

        static {
            icons = new IIcon[EnumBeeType.values().length][3];
        }
    }
}

