/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.network.PacketActiveUpdate;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.IActivatable;
import forestry.core.interfaces.IClimatised;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GuiUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TileBeehouse
extends TileBase
implements IBeeHousing,
IClimatised,
IActivatable {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    public static final int SLOT_PRODUCT_COUNT = 7;
    public static final int SLOT_FRAMES_1 = 9;
    public static final int SLOT_FRAMES_COUNT = 3;
    private final IBeekeepingLogic logic;
    private BiomeGenBase biome;
    private boolean active;
    private int displayHealthMax = 0;
    private int displayHealth = 0;
    private IBee displayQueen;

    public TileBeehouse() {
        this.setHints(Config.hints.get("apiary"));
        this.logic = BeeManager.beeRoot.createBeekeepingLogic(this);
        this.setInternalInventory(new BeehouseInventoryAdapter(this, 12, "Items").disableAutomation());
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.BeehouseGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("BiomeId", this.biome.field_76756_M);
        if (this.logic != null) {
            this.logic.writeToNBT(nbttagcompound);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        int biomeId = nbttagcompound.func_74762_e("BiomeId");
        this.biome = BiomeGenBase.func_150568_d((int)biomeId);
        this.logic.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.active);
        if (this.active) {
            ItemStack queen = this.func_70301_a(0);
            data.writeItemStack(queen);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.active = data.readBoolean();
        if (this.active) {
            ItemStack queen = data.readItemStack();
            this.func_70299_a(0, queen);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateBiome();
    }

    @Override
    public void func_145829_t() {
        this.updateBiome();
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.biome, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    @Deprecated
    public void setErrorState(IErrorState state) {
        this.removeErrorStates();
        if (state != EnumErrorCode.OK) {
            this.addErrorState(state);
        }
    }

    @Override
    @Deprecated
    public IErrorState getErrorState() {
        ImmutableSet<IErrorState> errorStates = this.getErrorStates();
        if (errorStates.size() == 0) {
            return EnumErrorCode.OK;
        }
        return (IErrorState)this.getErrorStates().iterator().next();
    }

    @Override
    public float getExactTemperature() {
        return this.biome.func_150564_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getExactHumidity() {
        return this.biome.field_76751_G;
    }

    @Override
    public void updateClientSide() {
        if (this.isActive() && this.displayQueen != null && this.updateOnInterval(4)) {
            this.displayQueen.doFX(this.logic.getEffectData(), this);
            if (this.updateOnInterval(50)) {
                float fxX = (float)this.field_145851_c + 0.5f;
                float fxY = (float)this.field_145848_d + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 6.0f / 16.0f;
                float fxZ = (float)this.field_145849_e + 0.5f;
                float f3 = 0.6f;
                float f4 = this.field_145850_b.field_73012_v.nextFloat() * f3 - 0.5f;
                Proxies.common.addEntitySwarmFX(this.field_145850_b, fxX - f3, fxY, fxZ + f4, 0.0f, 0.0f, 0.0f);
                Proxies.common.addEntitySwarmFX(this.field_145850_b, fxX + f3, fxY, fxZ + f4, 0.0f, 0.0f, 0.0f);
                Proxies.common.addEntitySwarmFX(this.field_145850_b, fxX + f4, fxY, fxZ - f3, 0.0f, 0.0f, 0.0f);
                Proxies.common.addEntitySwarmFX(this.field_145850_b, fxX + f4, fxY, fxZ + f3, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    @Override
    public void updateServerSide() {
        boolean canWork = this.logic.canWork();
        this.setActive(canWork);
        if (canWork) {
            this.logic.doWork();
        }
    }

    public boolean isWorking() {
        return !this.hasErrorState();
    }

    @Override
    public boolean addProduct(ItemStack product, boolean all) {
        return InvTools.tryAddStack((IInventory)this.getInternalInventory(), product, 2, 7, all, true);
    }

    @Override
    public void onQueenChange(ItemStack queenStack) {
    }

    private int getHealthDisplay() {
        if (this.displayQueen == null) {
            return 0;
        }
        if (this.displayQueen.getMate() != null) {
            return this.displayQueen.getHealth();
        }
        return this.displayHealth;
    }

    private int getMaxHealthDisplay() {
        if (this.displayQueen == null) {
            return 0;
        }
        if (this.displayQueen.getMate() != null) {
            return this.displayQueen.getMaxHealth();
        }
        return this.displayHealthMax;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    public void updateBiome() {
        BiomeGenBase biome;
        if (this.field_145850_b != null && (biome = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e)) != null) {
            this.biome = biome;
        }
    }

    public void getGUINetworkData(int i, int j) {
        if (this.logic == null) {
            return;
        }
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        if (this.logic == null) {
            return;
        }
        iCrafting.func_71112_a(container, 0, this.logic.getBreedingTime());
        iCrafting.func_71112_a(container, 1, this.logic.getTotalBreedingTime());
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.biome;
    }

    @Override
    public ItemStack getQueen() {
        return this.func_70301_a(0);
    }

    @Override
    public ItemStack getDrone() {
        return this.func_70301_a(1);
    }

    @Override
    public void setQueen(ItemStack itemstack) {
        this.func_70299_a(0, itemstack);
    }

    @Override
    public ItemStack func_70298_a(int slotIndex, int amount) {
        ItemStack itemStack = super.func_70298_a(slotIndex, amount);
        if (slotIndex == 0) {
            this.handleQueenChange();
        }
        return itemStack;
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        super.func_70299_a(slotIndex, itemStack);
        if (slotIndex == 0) {
            this.handleQueenChange();
        }
    }

    private void handleQueenChange() {
        if (!Proxies.common.isSimulating(this.field_145850_b)) {
            ItemStack itemStack = this.func_70301_a(0);
            this.displayQueen = BeeManager.beeRoot.getMember(itemStack);
        }
    }

    @Override
    public void setDrone(ItemStack itemstack) {
        this.func_70299_a(1, itemstack);
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public boolean canBreed() {
        return true;
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return 0.25f;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 0.0f;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 3.0f;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return 3.0f;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 0.0f;
    }

    @Override
    public void wearOutEquipment(int amount) {
    }

    @Override
    public boolean isSealed() {
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        return false;
    }

    @Override
    public boolean isHellish() {
        return false;
    }

    @Override
    public void onQueenDeath(IBee queen) {
    }

    @Override
    public void onPostQueenDeath(IBee queen) {
    }

    @Override
    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        return false;
    }

    @Override
    public boolean onEggLaid(IBee queen) {
        return false;
    }

    @Override
    public GameProfile getOwnerName() {
        return this.getOwner();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.field_145850_b.field_72995_K) {
            Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this));
        }
    }

    protected static class BeehouseInventoryAdapter
    extends TileInventoryAdapter<TileBeehouse> {
        public BeehouseInventoryAdapter(TileBeehouse tile, int size, String name) {
            super(tile, size, name);
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return BeeManager.beeRoot.isMember(itemStack) && !BeeManager.beeRoot.isDrone(itemStack);
            }
            if (GuiUtil.isIndexInRange(slotIndex, 9, 3)) {
                return itemStack.func_77973_b() instanceof IHiveFrame;
            }
            if (slotIndex == 1) {
                return BeeManager.beeRoot.isDrone(itemStack);
            }
            return false;
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
            return GuiUtil.isIndexInRange(slotIndex, 2, 7);
        }
    }
}

