/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mods.battlegear2.api.weapons.Attributes;
import mods.battlegear2.api.weapons.IExtendedReachWeapon;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TargetUtils {
    private static final int MAX_DISTANCE = 256;
    private static final double MAX_DISTANCE_SQ = 65536.0;
    private static final UUID reachModifierID = UUID.fromString("DC3DDFD0-56D1-4B1D-8B25-333C551FBC98");
    public static final Predicate<Entity> COLLIDABLE_ENTITY_SELECTOR = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity != null && entity.func_70067_L();
        }
    };
    public static final Predicate<Entity> HOSTILE_MOB_SELECTOR = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return TargetUtils.isMobEntity(entity);
        }
    };
    public static final Predicate<Entity> NON_PLAYER_SELECTOR = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return !(entity instanceof EntityPlayer);
        }
    };
    public static final TargetPredicate<Entity> NON_RIDING_SELECTOR = new TargetPredicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            if (entity == null) {
                return false;
            }
            if (this.seeker == null) {
                return true;
            }
            return entity.field_70154_o != this.seeker && this.seeker.field_70154_o != entity;
        }
    };
    public static final TargetPredicate<Entity> NON_TEAM_SELECTOR = new TargetPredicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof EntityLivingBase && (this.seeker == null || !((EntityLivingBase)entity).func_142014_c(this.seeker));
        }
    };
    public static final Predicate<Entity> VISIBLE_ENTITY_SELECTOR = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity != null && !entity.func_82150_aj();
        }
    };

    public static double getReachDistanceSq(EntityPlayer player) {
        if (DynamicSwordSkills.isBG2Enabled) {
            float reach = TargetUtils.getBattlegearReachDistance(player);
            return reach * reach;
        }
        return player.field_71075_bZ.field_75098_d ? 36.0 : 12.0;
    }

    @Optional.Method(modid="battlegear2")
    private static float getBattlegearReachDistance(EntityPlayer player) {
        float reachMod;
        ItemStack mainhand = player.func_71045_bC();
        float f = reachMod = player.field_71075_bZ.field_75098_d ? 5.0f : 4.5f;
        if (mainhand == null) {
            return reachMod - 2.2f;
        }
        if (mainhand.func_77973_b() instanceof ItemBlock) {
            return reachMod - 2.1f;
        }
        if (mainhand.func_77973_b() instanceof IExtendedReachWeapon) {
            reachMod = ((IExtendedReachWeapon)mainhand.func_77973_b()).getReachModifierInBlocks(mainhand);
        }
        return reachMod;
    }

    public static boolean canReachTarget(EntityPlayer player, Entity target) {
        return player.func_70685_l(target) && player.func_70068_e(target) < TargetUtils.getReachDistanceSq(player);
    }

    public static void applyExtendedReachModifier(EntityPlayer player, double range) {
        if (!DynamicSwordSkills.isBG2Enabled) {
            return;
        }
        double reach = Math.sqrt(TargetUtils.getReachDistanceSq(player));
        if (reach < range) {
            TargetUtils.removeExtendedReachModifier(player);
            IAttributeInstance instance = player.func_110148_a((IAttribute)Attributes.extendedReach);
            if (instance != null) {
                double mod = range - reach;
                AttributeModifier modifier = new AttributeModifier(reachModifierID, "Skill Reach Modifier", mod, 0).func_111168_a(false);
                instance.func_111121_a(modifier);
            }
        }
    }

    public static void removeExtendedReachModifier(EntityPlayer player) {
        AttributeModifier prev;
        if (!DynamicSwordSkills.isBG2Enabled) {
            return;
        }
        IAttributeInstance instance = player.func_110148_a((IAttribute)Attributes.extendedReach);
        if (instance != null && (prev = instance.func_111127_a(reachModifierID)) != null) {
            instance.func_111124_b(prev);
        }
    }

    public static MovingObjectPosition checkForImpact(World world, Entity entity, Entity shooter, double hitBox, boolean flag) {
        Vec3 vec3 = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        Vec3 vec31 = Vec3.func_72443_a((double)(entity.field_70165_t + entity.field_70159_w), (double)(entity.field_70163_u + entity.field_70181_x), (double)(entity.field_70161_v + entity.field_70179_y));
        MovingObjectPosition mop = world.func_147447_a(vec3, vec31, false, true, false);
        vec3 = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        vec31 = Vec3.func_72443_a((double)(entity.field_70165_t + entity.field_70159_w), (double)(entity.field_70163_u + entity.field_70181_x - (double)entity.field_70129_M), (double)(entity.field_70161_v + entity.field_70179_y));
        if (mop != null) {
            vec31 = Vec3.func_72443_a((double)mop.field_72307_f.field_72450_a, (double)mop.field_72307_f.field_72448_b, (double)mop.field_72307_f.field_72449_c);
        }
        Entity target = null;
        List list = world.func_72839_b(entity, entity.field_70121_D.func_72321_a(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition mop1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1 == shooter && !flag || (mop1 = (axisalignedbb = entity1.field_70121_D.func_72314_b(hitBox, hitBox, hitBox)).func_72327_a(vec3, vec31)) == null || !((d1 = vec3.func_72438_d(mop1.field_72307_f)) < d0) && d0 != 0.0) continue;
            target = entity1;
            d0 = d1;
        }
        if (target != null) {
            mop = new MovingObjectPosition(target);
        }
        if (mop != null && mop.field_72308_g instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)mop.field_72308_g;
            if (player.field_71075_bZ.field_75102_a || shooter instanceof EntityPlayer && !((EntityPlayer)shooter).func_96122_a(player)) {
                mop = null;
            }
        }
        return mop;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isMouseOverEntity(Entity entity) {
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        return mop != null && mop.field_72308_g == entity;
    }

    @SideOnly(value=Side.CLIENT)
    public static Entity getMouseOverEntity() {
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        return mop == null ? null : mop.field_72308_g;
    }

    public static final boolean isTargetValid(Entity target, EntityLivingBase seeker, List<Predicate<Entity>> filters) {
        if (target == seeker) {
            return false;
        }
        for (Predicate<Entity> p : filters) {
            if (p instanceof TargetPredicate) {
                ((TargetPredicate)p).setSeeker(seeker);
            }
            if (p.apply((Object)target)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isMobEntity(Entity entity) {
        IAttributeInstance damage;
        if (entity instanceof IMob || entity instanceof IRangedAttackMob) {
            return true;
        }
        if (entity instanceof EntityLiving && ((EntityLiving)entity).func_70638_az() != null) {
            return true;
        }
        return entity instanceof EntityLivingBase && (damage = ((EntityLivingBase)entity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e)) != null && damage.func_111126_e() > 0.0;
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius, boolean closestToSeeker) {
        return TargetUtils.acquireLookTarget(seeker, distance, radius, closestToSeeker, TargetUtils.getDefaultSelectors());
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius, boolean closestToSeeker, List<Predicate<Entity>> filters) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        EntityLivingBase currentTarget = null;
        double currentDistance = 65536.0;
        Vec3 vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            List list = seeker.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((targetX += vec3.field_72450_a) - radius), (double)((targetY += vec3.field_72448_b) - radius), (double)((targetZ += vec3.field_72449_c) - radius), (double)(targetX + radius), (double)(targetY + radius), (double)(targetZ + radius)));
            for (EntityLivingBase target : list) {
                if (!TargetUtils.isTargetValid((Entity)target, seeker, filters) || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target)) continue;
                double d = closestToSeeker ? target.func_70068_e((Entity)seeker) : target.func_70092_e(targetX, targetY, targetZ);
                double newDistance = d;
                if (!(newDistance < currentDistance)) continue;
                currentTarget = target;
                currentDistance = newDistance;
            }
        }
        return currentTarget;
    }

    public static final List<EntityLivingBase> acquireAllLookTargets(EntityLivingBase seeker, int distance, double radius) {
        return TargetUtils.acquireAllLookTargets(seeker, distance, radius, TargetUtils.getDefaultSelectors());
    }

    public static final List<EntityLivingBase> acquireAllLookTargets(EntityLivingBase seeker, int distance, double radius, List<Predicate<Entity>> filters) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        Vec3 vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            List list = seeker.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((targetX += vec3.field_72450_a) - radius), (double)((targetY += vec3.field_72448_b) - radius), (double)((targetZ += vec3.field_72449_c) - radius), (double)(targetX + radius), (double)(targetY + radius), (double)(targetZ + radius)));
            for (EntityLivingBase target : list) {
                if (!TargetUtils.isTargetValid((Entity)target, seeker, filters) || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target) || targets.contains(target)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    public static final boolean isTargetInFrontOf(Entity seeker, Entity target, float fov) {
        double dx = target.field_70165_t - seeker.field_70165_t;
        double dz = target.field_70161_v - seeker.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - seeker.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < fov && yaw > -fov;
    }

    public static final boolean isTargetInSight(EntityLivingBase seeker, Entity target) {
        return TargetUtils.isTargetInSight(seeker.func_70040_Z(), seeker, target);
    }

    private static final boolean isTargetInSight(Vec3 vec3, EntityLivingBase seeker, Entity target) {
        return seeker.func_70685_l(target) && TargetUtils.isTargetInFrontOf((Entity)seeker, target, 60.0f);
    }

    public static ChunkCoordinates getEntityCoordinates(Entity entity) {
        int i = MathHelper.func_76128_c((double)(entity.field_70165_t + 0.5));
        int j = MathHelper.func_76128_c((double)(entity.field_70163_u + 0.5 - (entity.field_70170_p.field_72995_K ? (double)entity.field_70129_M : 0.0)));
        int k = MathHelper.func_76128_c((double)(entity.field_70161_v + 0.5));
        return new ChunkCoordinates(i, j, k);
    }

    public static boolean isInLiquid(Entity entity) {
        ChunkCoordinates cc = TargetUtils.getEntityCoordinates(entity);
        Block block = entity.field_70170_p.func_147439_a(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
        return block.func_149688_o().func_76224_d();
    }

    public static final void knockTargetBack(EntityLivingBase pushedEntity, EntityLivingBase pushingEntity, float strength) {
        if (pushedEntity.func_70104_M()) {
            double dx = pushingEntity.field_70165_t - pushedEntity.field_70165_t;
            double dz = pushingEntity.field_70161_v - pushedEntity.field_70161_v;
            pushedEntity.func_70653_a((Entity)pushingEntity, strength, dx, dz);
        }
    }

    public static final List<Predicate<Entity>> getDefaultSelectors() {
        ArrayList list = Lists.newArrayList();
        list.add(COLLIDABLE_ENTITY_SELECTOR);
        list.add(NON_RIDING_SELECTOR);
        list.add(NON_TEAM_SELECTOR);
        list.add(VISIBLE_ENTITY_SELECTOR);
        return list;
    }

    public static abstract class TargetPredicate<T extends Entity>
    implements Predicate<T> {
        @Nullable
        protected EntityLivingBase seeker;

        public void setSeeker(@Nullable EntityLivingBase seeker) {
            this.seeker = seeker;
        }
    }
}

