/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.util;

import dynamicswordskills.api.IComboDamage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;

public class DamageUtils {
    public static final String ARMOR_BREAK = "armorBreak";
    public static final String INDIRECT_SWORD = "indirectSword";

    public static DamageSource causeArmorBreakDamage(Entity entity) {
        return new DamageSourceArmorBreak(ARMOR_BREAK, entity);
    }

    public static DamageSource causeIndirectSwordDamage(Entity direct, Entity indirect) {
        return new DamageSourceComboIndirect(INDIRECT_SWORD, direct, indirect, false);
    }

    public static DamageSource causeIndirectComboDamage(Entity direct, Entity indirect) {
        return new DamageSourceComboIndirect(INDIRECT_SWORD, direct, indirect, true);
    }

    public static class DamageSourceComboIndirect
    extends EntityDamageSourceIndirect
    implements IComboDamage.IComboDamageFull {
        private final boolean increaseCount;
        private final boolean mergeDamage;

        public DamageSourceComboIndirect(String name, Entity direct, Entity indirect) {
            this(name, direct, indirect, true);
        }

        public DamageSourceComboIndirect(String name, Entity direct, Entity indirect, boolean increaseCount) {
            this(name, direct, indirect, increaseCount, false);
        }

        public DamageSourceComboIndirect(String name, Entity direct, Entity indirect, boolean increaseCount, boolean mergeDamage) {
            super(name, direct, indirect);
            this.increaseCount = increaseCount;
            this.mergeDamage = mergeDamage;
        }

        @Override
        public boolean isComboDamage(EntityPlayer player) {
            return true;
        }

        @Override
        public boolean increaseComboCount(EntityPlayer player) {
            return this.increaseCount;
        }

        @Override
        public boolean applyDamageToPrevious(EntityPlayer player) {
            return this.mergeDamage;
        }

        @Override
        public boolean playDefaultSound(EntityPlayer player) {
            return true;
        }

        @Override
        public String getHitSound(EntityPlayer player) {
            return null;
        }
    }

    public static class DamageSourceArmorBreak
    extends EntityDamageSource
    implements IComboDamage.IComboDamageFull {
        private final boolean addHit;

        public DamageSourceArmorBreak(String name, Entity direct) {
            this(name, direct, true);
        }

        public DamageSourceArmorBreak(String name, Entity direct, boolean addHit) {
            super(name, direct);
            this.addHit = addHit;
            this.func_76348_h();
        }

        @Override
        public boolean isComboDamage(EntityPlayer player) {
            return true;
        }

        @Override
        public boolean increaseComboCount(EntityPlayer player) {
            return this.addHit;
        }

        @Override
        public boolean applyDamageToPrevious(EntityPlayer player) {
            return true;
        }

        @Override
        public boolean playDefaultSound(EntityPlayer player) {
            return true;
        }

        @Override
        public String getHitSound(EntityPlayer player) {
            return null;
        }
    }
}

