/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.skills.ArmorBreak;
import dynamicswordskills.skills.BackSlice;
import dynamicswordskills.skills.Dash;
import dynamicswordskills.skills.Dodge;
import dynamicswordskills.skills.EndingBlow;
import dynamicswordskills.skills.LeapingBlow;
import dynamicswordskills.skills.MortalDraw;
import dynamicswordskills.skills.Parry;
import dynamicswordskills.skills.RisingCut;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.SpinAttack;
import dynamicswordskills.skills.SuperSpinAttack;
import dynamicswordskills.skills.SwordBasic;
import dynamicswordskills.skills.SwordBeam;
import dynamicswordskills.skills.SwordBreak;
import net.minecraft.util.ResourceLocation;

public class Skills {
    public static final String ICON_LOCATION = "dynamicswordskills:textures/skills/";
    public static final SkillGroup DEFAULT_GROUP = new SkillGroup("dynamicswordskills", -1).register();
    public static final SkillGroup SWORD_GROUP = new SkillGroup("sword", 1).setHasTooltip().register();
    public static final SkillGroup TARGETED_GROUP = new SkillGroup("targeted", 0).setHasTooltip().register();
    public static final SkillGroup WEAPON_GROUP = new SkillGroup("weapon", 1).setHasTooltip().register();
    public static final SkillBase swordBasic = new SwordBasic("basic_technique").setIconLocation("dynamicswordskills:textures/skills/basic_technique.png").addDefaultTooltip().register("basic_technique");
    public static final SkillBase armorBreak = new ArmorBreak("armor_break").setIconLocation("dynamicswordskills:textures/skills/armor_break.png").addDefaultTooltip().register("armor_break");
    public static final SkillBase dodge = new Dodge("dodge").setIconLocation("dynamicswordskills:textures/skills/dodge.png").addDefaultTooltip().register("dodge");
    public static final SkillBase leapingBlow = new LeapingBlow("leaping_blow").setIconLocation("dynamicswordskills:textures/skills/leaping_blow.png").addDefaultTooltip().register("leaping_blow");
    public static final SkillBase parry = new Parry("parry").setIconLocation("dynamicswordskills:textures/skills/parry.png").addDefaultTooltip().register("parry");
    public static final SkillBase dash = new Dash("dash").setIconLocation("dynamicswordskills:textures/skills/dash.png").addDefaultTooltip().register("dash");
    public static final SkillBase spinAttack = new SpinAttack("spin_attack").setIconLocation("dynamicswordskills:textures/skills/basic_technique.png").addDefaultTooltip().register("spin_attack");
    public static final SkillBase superSpinAttack = new SuperSpinAttack("super_spin_attack").setIconLocation("dynamicswordskills:textures/skills/super_spin_attack.png").addDefaultTooltip().register("super_spin_attack");
    public static final SkillBase mortalDraw = new MortalDraw("mortal_draw").setIconLocation("dynamicswordskills:textures/skills/mortal_draw.png").addDefaultTooltip().register("mortal_draw");
    public static final SkillBase swordBreak = new SwordBreak("sword_break").setIconLocation("dynamicswordskills:textures/skills/sword_break.png").addDefaultTooltip().register("sword_break");
    public static final SkillBase risingCut = new RisingCut("rising_cut").setIconLocation("dynamicswordskills:textures/skills/rising_cut.png").addDefaultTooltip().register("rising_cut");
    public static final SkillBase endingBlow = new EndingBlow("ending_blow").setIconLocation("dynamicswordskills:textures/skills/ending_blow.png").addDefaultTooltip().register("ending_blow");
    public static final SkillBase backSlice = new BackSlice("back_slice").setIconLocation("dynamicswordskills:textures/skills/back_slice.png").addDefaultTooltip().register("back_slice");
    public static final SkillBase swordBeam = new SwordBeam("sword_beam").setIconLocation("dynamicswordskills:textures/skills/sword_beam.png").addDefaultTooltip().register("sword_beam");
    private static BiMap<Integer, ResourceLocation> skills_map = null;

    public static void init() {
        Skills.registerRemaps();
    }

    private static void registerRemaps() {
        Skills.remap("armorbreak", "armor_break");
        Skills.remap("backslice", "back_slice");
        Skills.remap("endingblow", "ending_blow");
        Skills.remap("leapingblow", "leaping_blow");
        Skills.remap("mortaldraw", "mortal_draw");
        Skills.remap("risingcut", "rising_cut");
        Skills.remap("spinattack", "spin_attack");
        Skills.remap("superspinattack", "super_spin_attack");
        Skills.remap("swordbasic", "basic_technique");
        Skills.remap("swordbeam", "sword_beam");
        Skills.remap("swordbreak", "sword_break");
    }

    private static void remap(String _old, String _new) {
        SkillRegistry.remap(new ResourceLocation("dynamicswordskills", _old), new ResourceLocation("dynamicswordskills", _new));
    }

    public static BiMap<Integer, ResourceLocation> getSkillIdMap() {
        if (skills_map != null) {
            return skills_map;
        }
        int i = 0;
        skills_map = HashBiMap.create((int)16);
        skills_map.put((Object)i++, (Object)swordBasic.getRegistryName());
        skills_map.put((Object)i++, (Object)armorBreak.getRegistryName());
        skills_map.put((Object)i++, (Object)dodge.getRegistryName());
        skills_map.put((Object)i++, (Object)leapingBlow.getRegistryName());
        skills_map.put((Object)i++, (Object)parry.getRegistryName());
        skills_map.put((Object)i++, (Object)dash.getRegistryName());
        skills_map.put((Object)i++, (Object)spinAttack.getRegistryName());
        skills_map.put((Object)i++, (Object)superSpinAttack.getRegistryName());
        skills_map.put((Object)i++, (Object)mortalDraw.getRegistryName());
        skills_map.put((Object)i++, (Object)swordBreak.getRegistryName());
        skills_map.put((Object)i++, (Object)risingCut.getRegistryName());
        skills_map.put((Object)i++, (Object)endingBlow.getRegistryName());
        skills_map.put((Object)i++, (Object)backSlice.getRegistryName());
        skills_map.put((Object)i++, (Object)swordBeam.getRegistryName());
        return skills_map;
    }
}

