/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Parry
extends SkillActive {
    private int parryTimer;
    private int attacksParried;
    @SideOnly(value=Side.CLIENT)
    private int keysPressed;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public Parry(String translationKey) {
        super(translationKey);
    }

    private Parry(Parry skill) {
        super(skill);
    }

    @Override
    public Parry newInstance() {
        return new Parry(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.WEAPON_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.chance"), (Object[])new Object[]{(int)(this.getDisarmChance(player, null) * 100.0f)}));
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.bonus"), (Object[])new Object[]{(int)(2.5f * (float)(this.getActiveTime() - this.getParryDelay()))}));
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.max"), (Object[])new Object[]{this.getMaxParries()}));
        desc.add(this.getTimeLimitDisplay(this.getActiveTime() - this.getParryDelay()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.parryTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 0.3f - 0.02f * (float)this.level;
    }

    private int getActiveTime() {
        return 9 + this.level / 2;
    }

    private int getParryDelay() {
        return 5 - this.level / 2;
    }

    private int getMaxParries() {
        return (1 + this.level) / 2;
    }

    private float getDisarmChance(EntityPlayer player, EntityLivingBase attacker) {
        float penalty = 0.05f * (float)this.attacksParried;
        float bonus = Config.getDisarmTimingBonus() * (float)(this.parryTimer > 0 ? this.parryTimer - this.getParryDelay() : 0);
        if (attacker instanceof EntityPlayer) {
            penalty += Config.getDisarmPenalty() * (float)DSSPlayerInfo.get((EntityPlayer)attacker).getSkillLevel(this);
        }
        return (float)this.level * 0.1f - penalty + bonus;
    }

    public float getKnockbackStrength() {
        return 0.4f;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && !player.func_71039_bw() && PlayerUtils.isWeapon(player.func_70694_bm());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.canUse(player) && this.keysPressed > 1 && this.ticksTilFail > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        return !Config.requiresLockOn() || isLockedOn;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (Config.allowVanillaControls() && key == mc.field_71474_y.field_74368_y || key == DSSKeyHandler.keys[4].getKey()) {
            this.ticksTilFail = 6;
            if (this.keysPressed < 2) {
                if (!Config.requiresDoubleTap() && key == DSSKeyHandler.keys[4].getKey()) {
                    ++this.keysPressed;
                }
                ++this.keysPressed;
            }
        } else {
            if (key == mc.field_71474_y.field_74313_G) {
                boolean flag = this.canExecute(player) && this.activate(player);
                this.ticksTilFail = 0;
                this.keysPressed = 0;
                return flag;
            }
            this.ticksTilFail = 0;
            this.keysPressed = 0;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.parryTimer = this.getActiveTime();
        this.attacksParried = 0;
        this.playMissSound = true;
        player.func_71038_i();
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.parryTimer = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.parryTimer <= this.getParryDelay() && this.playMissSound) {
                this.playMissSound = false;
                PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:swordmiss", 0.4f, 0.5f);
            }
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
            if (this.ticksTilFail < 1) {
                this.keysPressed = 0;
            }
        }
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            if (this.attacksParried < this.getMaxParries() && this.parryTimer > this.getParryDelay() && attacker.func_70694_bm() != null && PlayerUtils.isWeapon(player.func_70694_bm())) {
                if (player.field_70170_p.field_73012_v.nextFloat() < this.getDisarmChance(player, attacker)) {
                    PlayerUtils.dropHeldItem(attacker);
                }
                ++this.attacksParried;
                PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:swordstrike", 0.4f, 0.5f);
                this.playMissSound = false;
                TargetUtils.knockTargetBack(attacker, (EntityLivingBase)player, this.getKnockbackStrength());
                return true;
            }
        }
        return false;
    }
}

