/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DSSCombatEvents;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.entity.EntityLeapingBlow;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.util.PlayerUtils;
import dynamicswordskills.util.TargetUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;

public class LeapingBlow
extends SkillActive {
    private int ticksTilFail;
    private boolean isActive = false;

    public LeapingBlow(String translationKey) {
        super(translationKey);
    }

    private LeapingBlow(LeapingBlow skill) {
        super(skill);
    }

    @Override
    public LeapingBlow newInstance() {
        return new LeapingBlow(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.SWORD_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.level, true));
        desc.add(this.getRangeDisplay(3.0f + 0.5f * (float)this.level));
        desc.add(this.getAreaDisplay(0.5f + 0.25f * (float)this.level));
        desc.add(this.getDurationDisplay(this.getPotionDuration(player), false));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isAnimating() {
        return this.isActive() || this.ticksTilFail > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    @Override
    protected boolean autoAddExhaustion() {
        return false;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)this.level + player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    private int getPotionDuration(EntityPlayer player) {
        return 50 + this.level * 10;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isSwordOrProvider(player.func_70694_bm(), this) && !TargetUtils.isInLiquid((Entity)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.ticksTilFail > 0 && !player.field_70122_E && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        if (Config.requiresLockOn() && !isLockedOn) {
            return false;
        }
        return key == mc.field_71474_y.field_74314_A || key == mc.field_71474_y.field_74312_F;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == mc.field_71474_y.field_74314_A) {
            if (player.field_70122_E && mc.field_71474_y.field_74313_G.func_151470_d() && this.canUse(player)) {
                this.ticksTilFail = 10;
                return true;
            }
        } else if (this.canExecute(player) && this.activate(player)) {
            KeyBinding.func_74510_a((int)mc.field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
            DSSCombatEvents.setPlayerAttackTime(player);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.isActive = true;
        this.ticksTilFail = 0;
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.isActive = false;
        this.ticksTilFail = 0;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            if (this.isActive() && (player.field_70122_E || TargetUtils.isInLiquid((Entity)player))) {
                this.deactivate(player);
            } else if (this.ticksTilFail > 0) {
                --this.ticksTilFail;
            }
        }
    }

    @Override
    public boolean onFall(EntityPlayer player, LivingFallEvent event) {
        this.onFall(player, event.distance);
        return true;
    }

    @Override
    public boolean onCreativeFall(EntityPlayer player, PlayerFlyableFallEvent event) {
        this.onFall(player, event.distance);
        return true;
    }

    private void onFall(EntityPlayer player, float distance) {
        if (this.isActive() && PlayerUtils.isSwordOrProvider(player.func_70694_bm(), this)) {
            if (player.field_70170_p.field_72995_K) {
                if (distance < 1.0f) {
                    DSSClientEvents.handlePlayerAttack(Minecraft.func_71410_x());
                } else {
                    player.func_71038_i();
                }
            } else if (distance >= 1.0f) {
                player.func_71020_j(this.getExhaustion());
                EntityLeapingBlow entity = new EntityLeapingBlow(player.field_70170_p, (EntityLivingBase)player).setDamage(this.getDamage(player)).setLevel(this.level);
                player.field_70170_p.func_72838_d((Entity)entity);
                PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:leapingblow", 0.4f, 0.5f);
            }
        }
        this.onDeactivated(player.field_70170_p, player);
    }
}

