/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.api.SkillGroup;
import dynamicswordskills.client.DSSClientEvents;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.ActionTimePacket;
import dynamicswordskills.network.client.EndingBlowPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.IComboSkill;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.Skills;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EndingBlow
extends SkillActive {
    private int activeTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    @SideOnly(value=Side.CLIENT)
    private int keyPressed;
    @SideOnly(value=Side.CLIENT)
    private boolean keyReleased;
    @SideOnly(value=Side.CLIENT)
    private long lastActivationTime;
    public byte skillResult;
    private int lastNumHits;
    private EntityLivingBase entityHit;
    private int xp;

    public EndingBlow(String translationKey) {
        super(translationKey);
    }

    private EndingBlow(EndingBlow skill) {
        super(skill);
    }

    @Override
    public EndingBlow newInstance() {
        return new EndingBlow(this);
    }

    @Override
    public boolean displayInGroup(SkillGroup group) {
        return super.displayInGroup(group) || group == Skills.WEAPON_GROUP || group == Skills.TARGETED_GROUP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.level * 20, true) + "%");
        desc.add(this.getDurationDisplay(this.getDuration(), true));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - (float)this.level * 0.1f;
    }

    public int getDuration() {
        return 45 - this.level * 5;
    }

    @SideOnly(value=Side.CLIENT)
    public long getLastActivationTime() {
        return this.lastActivationTime;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        IComboSkill combo;
        if (!this.isActive() && super.canUse(player) && PlayerUtils.isWeapon(player.func_70694_bm()) && (combo = DSSPlayerInfo.get(player).getComboSkill()) != null && combo.isComboInProgress()) {
            ILockOnTarget lock = DSSPlayerInfo.get(player).getTargetingSkill();
            if (lock == null || lock.isLockedOn() && lock.getCurrentTarget() != combo.getCombo().getLastEntityHit()) {
                return false;
            }
            if (this.lastNumHits > 0) {
                return combo.getCombo().getConsecutiveHits() > 1 && combo.getCombo().getNumHits() > this.lastNumHits + 2;
            }
            return combo.getCombo().getConsecutiveHits() > 1;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.ticksTilFail > 0 && this.keyPressed > 1 && this.keyReleased && this.canUse(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        if (Config.requiresLockOn() && !isLockedOn) {
            return false;
        }
        return key == mc.field_71474_y.field_74312_F || key == DSSKeyHandler.keys[3].getKey() || Config.allowVanillaControls() && key == mc.field_71474_y.field_74351_w;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == DSSKeyHandler.keys[3].getKey() || Config.allowVanillaControls() && key == mc.field_71474_y.field_74351_w) {
            if (this.ticksTilFail == 0) {
                this.ticksTilFail = 6;
            }
            ++this.keyPressed;
        } else if (this.canExecute(player)) {
            this.ticksTilFail = 0;
            this.keyPressed = 0;
            this.keyReleased = false;
            return this.activate(player);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void keyReleased(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == DSSKeyHandler.keys[3].getKey() || Config.allowVanillaControls() && key == mc.field_71474_y.field_74351_w) {
            this.keyReleased = this.keyPressed > 0 && this.ticksTilFail > 0;
        }
    }

    @Override
    protected boolean onActivated(World world, EntityPlayer player) {
        this.activeTimer = 3;
        this.entityHit = null;
        IComboSkill skill = DSSPlayerInfo.get(player).getComboSkill();
        if (skill != null && skill.getCombo() != null) {
            this.lastNumHits = skill.getCombo().getNumHits();
        }
        if (world.field_72995_K) {
            DSSClientEvents.handlePlayerAttack(Minecraft.func_71410_x());
            this.lastActivationTime = Minecraft.func_71386_F();
            this.skillResult = 0;
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.activeTimer = 0;
        this.entityHit = null;
        this.xp = 0;
        if (world.field_72995_K) {
            this.keyPressed = 0;
            this.keyReleased = false;
            this.ticksTilFail = 0;
        }
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
            if (this.ticksTilFail == 0) {
                this.keyPressed = 0;
                this.keyReleased = false;
            }
        }
        if (this.lastNumHits > 0) {
            IComboSkill skill;
            if (this.entityHit != null && this.xp > 0) {
                this.updateEntityState(player);
            }
            if ((skill = DSSPlayerInfo.get(player).getComboSkill()) == null || !skill.isComboInProgress()) {
                this.lastNumHits = 0;
            }
        }
        if (this.isActive()) {
            --this.activeTimer;
            if (this.activeTimer == 0 && !player.field_70170_p.field_72995_K) {
                this.onFail(player, true);
            }
        }
    }

    private void updateEntityState(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            if (this.entityHit.func_110143_aJ() <= 0.0f) {
                if (this.entityHit instanceof EntityLiving) {
                    DirtyEntityAccessor.setLivingXp((EntityLiving)this.entityHit, this.xp, true);
                } else {
                    PlayerUtils.spawnXPOrbsWithRandom(player.field_70170_p, player.field_70170_p.field_73012_v, MathHelper.func_76128_c((double)this.entityHit.field_70165_t), MathHelper.func_76128_c((double)this.entityHit.field_70163_u), MathHelper.func_76128_c((double)this.entityHit.field_70161_v), this.xp);
                }
                PacketDispatcher.sendTo(new EndingBlowPacket(1), (EntityPlayerMP)player);
            } else {
                this.onFail(player, false);
            }
        }
        this.entityHit = null;
        this.xp = 0;
    }

    @Override
    public float onImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        IComboSkill combo = DSSPlayerInfo.get(player).getComboSkill();
        if (combo != null && combo.isComboInProgress() && entity == combo.getCombo().getLastEntityHit() && combo.getCombo().getConsecutiveHits() > 1) {
            amount *= 1.0f + (float)this.level * 0.2f;
            PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:mortaldraw", 0.4f, 0.5f);
            this.entityHit = entity;
        } else if (!player.field_70170_p.field_72995_K) {
            this.onFail(player, false);
        }
        return amount;
    }

    @Override
    public void postImpact(EntityPlayer player, EntityLivingBase entity, float amount) {
        this.activeTimer = 0;
        if (this.entityHit != null) {
            this.xp = this.level + 1 + player.field_70170_p.field_73012_v.nextInt(Math.max(2, MathHelper.func_76123_f((float)entity.func_110143_aJ())));
        }
    }

    private void onFail(EntityPlayer player, boolean timedOut) {
        if (!player.field_71075_bZ.field_75098_d) {
            DSSPlayerInfo skills = DSSPlayerInfo.get(player);
            int t = this.getDuration() * (timedOut ? 2 : 1);
            skills.setAttackCooldown(t);
            PacketDispatcher.sendTo(new ActionTimePacket(skills.getAttackTime(), true), (EntityPlayerMP)player);
        }
        if (!timedOut) {
            PlayerUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "dynamicswordskills:hurtflesh", 0.3f, 0.8f);
        }
        PacketDispatcher.sendTo(new EndingBlowPacket(-1), (EntityPlayerMP)player);
    }
}

