/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.client.DSSKeyHandler;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.util.PlayerUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Dodge
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keyPressed;
    private int ticksTilFail;
    private boolean keyReleased;
    private Vec3 trajectory;
    private int dodgeTimer = 0;
    private Entity entityDodged;

    public Dodge(String translationKey) {
        super(translationKey);
    }

    private Dodge(Dodge skill) {
        super(skill);
    }

    @Override
    public Dodge newInstance() {
        return new Dodge(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.chance"), (Object[])new Object[]{(int)(this.getBaseDodgeChance(player) * 100.0f)}));
        desc.add(StatCollector.func_74837_a((String)(this.getTranslationKey() + ".info.bonus"), (Object[])new Object[]{this.level * 4}));
        desc.add(this.getTimeLimitDisplay(this.getDodgeTime()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.dodgeTimer > 0;
    }

    @Override
    protected float getExhaustion() {
        return 0.05f;
    }

    private float getBaseDodgeChance(EntityPlayer player) {
        float speedBonus = 2.0f * (float)(player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e() - (double)0.1f);
        return (float)this.level * 0.1f + speedBonus;
    }

    private float getDodgeChance(EntityPlayer player) {
        return this.getBaseDodgeChance(player) + this.getTimeBonus();
    }

    private int getDodgeTime() {
        return 5 + this.level;
    }

    private float getTimeBonus() {
        return (float)(this.dodgeTimer + this.level - 5) * 0.02f;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && !PlayerUtils.isBlocking(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && this.canUse(player) && this.keyReleased && this.ticksTilFail > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isKeyListener(Minecraft mc, KeyBinding key, boolean isLockedOn) {
        return !Config.requiresLockOn() || isLockedOn;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(Minecraft mc, KeyBinding key, EntityPlayer player) {
        if (key == this.keyPressed) {
            boolean flag = this.canExecute(player) && this.activate(player);
            this.resetKeyState(flag);
            return flag;
        }
        if (Config.allowVanillaControls() && (key == mc.field_71474_y.field_74370_x || key == mc.field_71474_y.field_74366_z)) {
            this.firstKeyPress(mc, key, player);
        } else if (key == DSSKeyHandler.keys[5].getKey() || key == DSSKeyHandler.keys[6].getKey()) {
            if (key == DSSKeyHandler.keys[5].getKey() && mc.field_71474_y.field_74366_z.func_151470_d()) {
                return false;
            }
            if (key == DSSKeyHandler.keys[6].getKey() && mc.field_71474_y.field_74370_x.func_151470_d()) {
                return false;
            }
            this.firstKeyPress(mc, key, player);
            if (!Config.requiresDoubleTap()) {
                this.keyReleased = true;
                boolean flag = this.canExecute(player) && this.activate(player);
                this.resetKeyState(true);
                return flag;
            }
        } else {
            this.keyPressed = null;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void firstKeyPress(Minecraft mc, KeyBinding key, EntityPlayer player) {
        this.keyPressed = key;
        this.keyReleased = false;
        this.ticksTilFail = 6;
    }

    @SideOnly(value=Side.CLIENT)
    private void resetKeyState(boolean flag) {
        this.keyReleased = false;
        this.ticksTilFail = 0;
        if (!flag) {
            this.keyPressed = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void keyReleased(Minecraft mc, KeyBinding key, EntityPlayer player) {
        boolean bl = this.keyReleased = key == this.keyPressed;
        if (this.keyReleased && this.ticksTilFail < 1) {
            this.keyPressed = null;
        }
    }

    @Override
    public boolean onActivated(World world, EntityPlayer player) {
        this.dodgeTimer = this.getDodgeTime();
        this.entityDodged = null;
        if (player.field_70170_p.field_72995_K) {
            this.trajectory = player.func_70040_Z();
            this.trajectory = this.keyPressed == DSSKeyHandler.keys[6].getKey() || this.keyPressed == Minecraft.func_71410_x().field_71474_y.field_74366_z ? Vec3.func_72443_a((double)(-this.trajectory.field_72449_c), (double)0.0, (double)this.trajectory.field_72450_a) : Vec3.func_72443_a((double)this.trajectory.field_72449_c, (double)0.0, (double)(-this.trajectory.field_72450_a));
            this.keyPressed = null;
        }
        return this.isActive();
    }

    @Override
    protected void onDeactivated(World world, EntityPlayer player) {
        this.dodgeTimer = 0;
        this.entityDodged = null;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            --this.dodgeTimer;
        }
        if (this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAnimating() {
        return this.dodgeTimer > this.level && this.trajectory != null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player, float partialTickTime) {
        double speed = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        double fps = 30.0f / (float)DynamicSwordSkills.proxy.getDebugFPS();
        double d = 1.15 * fps * speed;
        if (player.func_70090_H() || player.func_70058_J()) {
            d *= 0.15;
        }
        player.func_70024_g(this.trajectory.field_72450_a * d, -0.02 * fps, this.trajectory.field_72449_c * d);
        return true;
    }

    @Override
    public boolean onBeingAttacked(EntityPlayer player, DamageSource source) {
        Entity attacker;
        if (this.dodgeTimer > this.level && (attacker = source.func_76346_g()) != null) {
            return attacker == this.entityDodged || this.dodgeAttack(player, attacker);
        }
        return false;
    }

    private boolean dodgeAttack(EntityPlayer player, Entity attacker) {
        if (player.field_70170_p.field_73012_v.nextFloat() < this.getDodgeChance(player)) {
            this.entityDodged = attacker;
            PlayerUtils.playRandomizedSound(player, "dynamicswordskills:swordmiss", 0.4f, 0.5f);
            return true;
        }
        return false;
    }
}

