/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.network.client;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.network.AbstractMessage;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class SyncConfigPacket
extends AbstractMessage.AbstractClientMessage<SyncConfigPacket> {
    private boolean isValid;
    public int baseSwingSpeed;
    public boolean requireFullHealth;
    public List<Byte> disabledIds = Lists.newArrayList();

    public final boolean isMessageValid() {
        return this.isValid;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.baseSwingSpeed = buffer.readInt();
        this.requireFullHealth = buffer.readBoolean();
        this.isValid = true;
        int n = buffer.readInt();
        for (int i = 0; i < n; ++i) {
            this.disabledIds.add(buffer.readByte());
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(Config.getBaseSwingSpeed());
        buffer.writeBoolean(Config.getHealthAllowance(1) == 0.0f);
        for (SkillBase skill : SkillRegistry.getValues()) {
            if (Config.isSkillAllowed(skill)) continue;
            this.disabledIds.add(skill.getId());
        }
        buffer.writeInt(this.disabledIds.size());
        for (Byte b : this.disabledIds) {
            buffer.writeByte((int)b.byteValue());
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        Config.syncClientSettings(this);
    }
}

