/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.entity;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.IComboDamage;
import dynamicswordskills.api.IMetadataSkillItem;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.SyncPlayerInfoPacket;
import dynamicswordskills.network.client.SyncSkillPacket;
import dynamicswordskills.network.server.ApplySkillModifierPacket;
import dynamicswordskills.network.server.SyncDisabledSkillsPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.IComboSkill;
import dynamicswordskills.skills.ILockOnTarget;
import dynamicswordskills.skills.IModifiableSkill;
import dynamicswordskills.skills.ISkillModifier;
import dynamicswordskills.skills.MortalDraw;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.Skills;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;

public class DSSPlayerInfo
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "DSSPlayerInfo";
    private static final int MAX_CLICK_COOLDOWN = 50;
    private final EntityPlayer player;
    private int useItemCooldown;
    private final Map<Byte, SkillBase> skills;
    private Set<Byte> disabledSkillIds = Sets.newHashSet();
    private IComboSkill comboSkill = null;
    private boolean invalidateCombo;
    private ILockOnTarget targetingSkill = null;
    private SkillBase itemSkill = null;
    private ItemStack lastCheckedStack = null;
    private SkillBase dummySwordSkill = null;
    @SideOnly(value=Side.CLIENT)
    private SkillActive animatingSkill;
    private boolean receivedGear = false;
    public float swingProgress = 0.0f;
    public float prevSwingProgress = 0.0f;

    public DSSPlayerInfo(EntityPlayer player) {
        this.player = player;
        this.skills = new HashMap<Byte, SkillBase>(SkillRegistry.getValues().size());
    }

    public void init(Entity entity, World world) {
    }

    public boolean canAttack() {
        return this.player.field_70724_aR == 0 || this.player.field_71075_bZ.field_75098_d;
    }

    public int getAttackTime() {
        return this.player.field_70724_aR;
    }

    public void setAttackCooldown(int ticks) {
        this.player.field_70724_aR = MathHelper.func_76125_a((int)ticks, (int)this.player.field_70724_aR, (int)50);
    }

    public boolean canUseItem() {
        return this.useItemCooldown == 0 || this.player.field_71075_bZ.field_75098_d;
    }

    public int getUseItemCooldown() {
        return this.useItemCooldown;
    }

    public void setUseItemCooldown(int ticks) {
        this.useItemCooldown = MathHelper.func_76125_a((int)ticks, (int)this.useItemCooldown, (int)50);
    }

    public void setArmSwingProgress(float current, float previous) {
        this.swingProgress = current;
        this.prevSwingProgress = previous;
    }

    public boolean removeSkill(String name) {
        if ("all".equals(name)) {
            this.resetSkills();
            return true;
        }
        SkillBase dummy = null;
        for (SkillBase skill : this.skills.values()) {
            if (!skill.getRegistryName().toString().equals(name)) continue;
            dummy = skill;
            break;
        }
        if (dummy != null) {
            this.removeSkill(dummy);
            return true;
        }
        return false;
    }

    private void removeSkill(SkillBase skill) {
        SkillBase dummy = skill.newInstance();
        this.skills.put(dummy.getId(), dummy);
        this.validateSkills();
        this.skills.remove(dummy.getId());
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncSkillPacket(dummy), (EntityPlayerMP)this.player);
        }
    }

    public void resetSkills() {
        for (SkillBase skill : SkillRegistry.getValues()) {
            this.skills.put(skill.getId(), skill.newInstance());
        }
        this.validateSkills();
        this.skills.clear();
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncPlayerInfoPacket(this).setReset(), (EntityPlayerMP)this.player);
        }
    }

    public boolean hasSkill(SkillBase skill) {
        return this.getSkillLevel(skill) > 0;
    }

    public byte getSkillLevel(SkillBase skill) {
        byte level = 0;
        if (skill == null) {
            return 0;
        }
        if (skill.is(this.itemSkill)) {
            level = this.itemSkill.getLevel();
        } else if (skill.is(this.dummySwordSkill)) {
            level = this.dummySwordSkill.getLevel();
        }
        return (byte)Math.max(level, this.getTrueSkillLevel(skill));
    }

    public byte getTrueSkillLevel(SkillBase skill) {
        return this.skills.containsKey(skill.getId()) ? this.skills.get(skill.getId()).getLevel() : (byte)0;
    }

    public boolean canUseSkill(SkillBase skill) {
        SkillActive active = this.getActiveSkill(skill);
        return active != null && active.canUse(this.player);
    }

    public boolean isSkillActive(SkillBase skill) {
        SkillBase active = this.getPlayerSkill(skill);
        return active instanceof SkillActive && ((SkillActive)active).isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public SkillActive getCurrentlyAnimatingSkill() {
        return this.animatingSkill;
    }

    @SideOnly(value=Side.CLIENT)
    public void setCurrentlyAnimatingSkill(SkillActive skill) {
        this.animatingSkill = skill == null || skill.hasAnimation() ? skill : this.animatingSkill;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canInteract() {
        return this.animatingSkill == null || !this.animatingSkill.isAnimating();
    }

    @SideOnly(value=Side.CLIENT)
    public <T extends SkillActive> void onKeyPressedWhileAnimating(Minecraft mc, KeyBinding key) {
        boolean isLockedOn;
        boolean bl = isLockedOn = this.targetingSkill != null && this.targetingSkill.isLockedOn();
        if (this.animatingSkill != null && this.animatingSkill.isKeyListener(mc, key, isLockedOn)) {
            this.animatingSkill.keyPressedWhileAnimating(mc, key, this.player);
        }
        if (this.animatingSkill instanceof IModifiableSkill) {
            this.applyKeyPressSkillModifiers(this.animatingSkill, mc, key);
        }
        if (isLockedOn && this.targetingSkill instanceof SkillActive && this.targetingSkill != this.animatingSkill) {
            if (((SkillActive)((Object)this.targetingSkill)).isKeyListener(mc, key, isLockedOn)) {
                ((SkillActive)((Object)this.targetingSkill)).keyPressedWhileAnimating(mc, key, this.player);
            }
            if (this.targetingSkill instanceof IModifiableSkill) {
                this.applyKeyPressSkillModifiers((SkillActive)((Object)this.targetingSkill), mc, key);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private <T extends SkillActive, M extends SkillBase> void applyKeyPressSkillModifiers(T parent, Minecraft mc, KeyBinding key) {
        for (SkillBase t : ((IModifiableSkill)((Object)parent)).getSkillModifiers()) {
            SkillBase instance;
            if (Config.isSkillDisabled(this.player, t) || !((instance = this.getPlayerSkill(t)) instanceof ISkillModifier) || instance.getLevel() <= 0 || !((ISkillModifier)((Object)instance)).applyOnKeyPress(mc, key, this.player)) continue;
            ((IModifiableSkill)((Object)parent)).applySkillModifier(instance, this.player);
            PacketDispatcher.sendToServer(new ApplySkillModifierPacket(parent, instance));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyPressed(Minecraft mc, KeyBinding key) {
        boolean isLockedOn = this.targetingSkill != null && this.targetingSkill.isLockedOn();
        for (SkillBase skill : this.skills.values()) {
            if (Config.isSkillDisabled(this.player, skill) || !(skill instanceof SkillActive) || !((SkillActive)skill).isKeyListener(mc, key, isLockedOn) || !((SkillActive)skill).keyPressed(mc, key, this.player)) continue;
            return true;
        }
        if (this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isKeyListener(mc, key, isLockedOn) && ((SkillActive)this.itemSkill).keyPressed(mc, key, this.player)) {
            return true;
        }
        return this.dummySwordSkill instanceof SkillActive && ((SkillActive)this.dummySwordSkill).isKeyListener(mc, key, isLockedOn) && ((SkillActive)this.dummySwordSkill).keyPressed(mc, key, this.player);
    }

    @SideOnly(value=Side.CLIENT)
    public void onKeyReleased(Minecraft mc, KeyBinding key) {
        boolean isLockedOn = this.targetingSkill != null && this.targetingSkill.isLockedOn();
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isKeyListener(mc, key, isLockedOn)) continue;
            ((SkillActive)skill).keyReleased(mc, key, this.player);
        }
        if (this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isKeyListener(mc, key, isLockedOn)) {
            ((SkillActive)this.itemSkill).keyReleased(mc, key, this.player);
        }
        if (this.dummySwordSkill instanceof SkillActive && ((SkillActive)this.dummySwordSkill).isKeyListener(mc, key, isLockedOn)) {
            ((SkillActive)this.dummySwordSkill).keyReleased(mc, key, this.player);
        }
    }

    public void onAttack(LivingAttackEvent event) {
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isActive() || !((SkillActive)skill).onAttack(this.player, event.entityLiving, event.source, event.ammount)) continue;
            event.setCanceled(true);
            return;
        }
        if (this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isActive()) {
            event.setCanceled(((SkillActive)this.itemSkill).onAttack(this.player, event.entityLiving, event.source, event.ammount));
        }
        if (!event.isCanceled() && this.dummySwordSkill instanceof SkillActive && ((SkillActive)this.dummySwordSkill).isActive()) {
            event.setCanceled(((SkillActive)this.dummySwordSkill).onAttack(this.player, event.entityLiving, event.source, event.ammount));
        }
    }

    public void onBeingAttacked(LivingAttackEvent event) {
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isActive() || !((SkillActive)skill).onBeingAttacked(this.player, event.source)) continue;
            event.setCanceled(true);
            return;
        }
        if (this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isActive()) {
            ((SkillActive)this.itemSkill).onBeingAttacked(this.player, event.source);
            event.setCanceled(((SkillActive)this.itemSkill).onBeingAttacked(this.player, event.source));
        }
        if (!event.isCanceled() && this.dummySwordSkill instanceof SkillActive && ((SkillActive)this.dummySwordSkill).isActive()) {
            event.setCanceled(((SkillActive)this.dummySwordSkill).onBeingAttacked(this.player, event.source));
        }
    }

    public void onImpact(LivingHurtEvent event) {
        for (SkillBase skill : this.skills.values()) {
            if (event.isCanceled() || event.ammount <= 0.0f) {
                return;
            }
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isActive()) continue;
            event.ammount = ((SkillActive)skill).onImpact(this.player, event.entityLiving, event.ammount);
        }
        if (!event.isCanceled() && event.ammount > 0.0f && this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isActive()) {
            event.ammount = ((SkillActive)this.itemSkill).onImpact(this.player, event.entityLiving, event.ammount);
        }
        if (!event.isCanceled() && event.ammount > 0.0f && this.dummySwordSkill instanceof SkillActive && ((SkillActive)this.dummySwordSkill).isActive()) {
            event.ammount = ((SkillActive)this.dummySwordSkill).onImpact(this.player, event.entityLiving, event.ammount);
        }
    }

    public void onPostImpact(LivingHurtEvent event) {
        for (SkillBase skill : this.skills.values()) {
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isActive()) continue;
            ((SkillActive)skill).postImpact(this.player, event.entityLiving, event.ammount);
        }
        if (this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isActive()) {
            ((SkillActive)this.itemSkill).postImpact(this.player, event.entityLiving, event.ammount);
        }
        if (this.dummySwordSkill instanceof SkillActive && ((SkillActive)this.dummySwordSkill).isActive()) {
            ((SkillActive)this.dummySwordSkill).postImpact(this.player, event.entityLiving, event.ammount);
        }
        if (!event.isCanceled() && event.ammount > 0.0f && this.getComboSkill() != null && ((SkillActive)((Object)this.getComboSkill())).isActive() && (!(event.source instanceof IComboDamage) || ((IComboDamage)event.source).isComboDamage(this.player))) {
            this.getComboSkill().onHurtTarget(this.player, event);
        }
    }

    public void onFall(LivingFallEvent event) {
        for (SkillBase skill : this.skills.values()) {
            if (event.isCanceled() || event.distance <= 0.0f) {
                return;
            }
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isActive() || !((SkillActive)skill).onFall(this.player, event)) continue;
            return;
        }
        if (!event.isCanceled() && event.distance > 0.0f && this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isActive() && ((SkillActive)this.itemSkill).onFall(this.player, event)) {
            return;
        }
        if (!event.isCanceled() && event.distance > 0.0f && this.dummySwordSkill instanceof SkillActive && ((SkillActive)this.dummySwordSkill).isActive() && ((SkillActive)this.dummySwordSkill).onFall(this.player, event)) {
            return;
        }
    }

    public void onCreativeFall(PlayerFlyableFallEvent event) {
        for (SkillBase skill : this.skills.values()) {
            if (event.distance <= 0.0f) {
                return;
            }
            if (!(skill instanceof SkillActive) || !((SkillActive)skill).isActive() || !((SkillActive)skill).onCreativeFall(this.player, event)) continue;
            return;
        }
        if (event.distance > 0.0f && this.itemSkill instanceof SkillActive && ((SkillActive)this.itemSkill).isActive() && ((SkillActive)this.itemSkill).onCreativeFall(this.player, event)) {
            return;
        }
        if (event.distance > 0.0f && this.dummySwordSkill instanceof SkillActive && ((SkillActive)this.dummySwordSkill).isActive() && ((SkillActive)this.dummySwordSkill).onCreativeFall(this.player, event)) {
            return;
        }
    }

    private boolean retrieveDummySwordSkill() {
        ItemStack stack;
        int swordSlot = MortalDraw.getSwordSlot(this.player);
        if (swordSlot > -1 && (stack = this.player.field_71071_by.func_70301_a(swordSlot)) != null && stack.func_77973_b() instanceof ISkillProvider) {
            boolean needsDummy;
            boolean flag = false;
            boolean bl = needsDummy = this.getTrueSkillLevel(Skills.swordBasic) < 1;
            if (needsDummy && ((ISkillProvider)stack.func_77973_b()).grantsBasicSwordSkill(stack)) {
                flag = true;
                if (this.dummySwordSkill == null) {
                    this.dummySwordSkill = SkillBase.createLeveledSkill(Skills.swordBasic, (byte)1);
                }
            }
            byte plvl = this.getTrueSkillLevel(Skills.mortalDraw);
            SkillBase skill = SkillBase.getSkillFromItem(stack, (ISkillProvider)stack.func_77973_b());
            if (Skills.mortalDraw.is(skill) && skill.getLevel() > plvl) {
                flag = true;
                if (this.itemSkill == null || !skill.equals(this.itemSkill)) {
                    this.itemSkill = skill;
                }
            }
            if (flag && !Skills.mortalDraw.is(this.itemSkill)) {
                this.itemSkill = null;
            }
            return flag;
        }
        return false;
    }

    @Nullable
    public SkillActive getActiveSkill(@Nullable SkillBase skill) {
        SkillBase active = this.getPlayerSkill(skill);
        return active instanceof SkillActive ? (SkillActive)active : null;
    }

    @Nullable
    public SkillBase getPlayerSkill(@Nullable SkillBase skill) {
        if (skill == null) {
            return null;
        }
        if (skill.is(this.itemSkill)) {
            return this.itemSkill;
        }
        if (skill.is(this.dummySwordSkill)) {
            return this.dummySwordSkill;
        }
        return this.getTruePlayerSkill(skill);
    }

    @Nullable
    public SkillBase getTruePlayerSkill(SkillBase skill) {
        return this.skills.containsKey(skill.getId()) ? this.skills.get(skill.getId()) : null;
    }

    public IComboSkill getComboSkill() {
        if (this.comboSkill == null || this.comboSkill.getCombo() == null || !((SkillActive)((Object)this.comboSkill)).isActive()) {
            IComboSkill combo = this.getFirstActiveComboSkill();
            if (combo != null) {
                this.comboSkill = combo;
                this.invalidateCombo = false;
            } else if (this.comboSkill != null && !this.comboSkill.isComboInProgress()) {
                this.invalidateCombo = true;
            }
        }
        return this.comboSkill;
    }

    private IComboSkill getFirstActiveComboSkill() {
        for (SkillBase skill : SkillRegistry.getValues()) {
            SkillBase instance;
            if (!(skill instanceof IComboSkill) || !(skill instanceof SkillActive) || (instance = this.getPlayerSkill(skill)) == null || !((SkillActive)instance).isActive()) continue;
            return (IComboSkill)((Object)instance);
        }
        return null;
    }

    public void activateTargetingSkill() {
        SkillBase instance;
        SkillBase skill;
        if (this.getTargetingSkill() != null) {
            return;
        }
        Iterator<SkillBase> iterator = SkillRegistry.getValues().iterator();
        while (!(!iterator.hasNext() || (skill = iterator.next()) instanceof ILockOnTarget && skill instanceof SkillActive && (instance = this.getPlayerSkill(skill)) != null && ((SkillActive)instance).activate(this.player))) {
        }
    }

    public void deactivateTargetingSkill() {
        this.getTargetingSkill();
        if (this.targetingSkill != null) {
            ((SkillActive)((Object)this.targetingSkill)).deactivate(this.player);
        }
    }

    public ILockOnTarget getTargetingSkill() {
        if (this.targetingSkill == null || !((SkillActive)((Object)this.targetingSkill)).isActive()) {
            this.targetingSkill = this.getFirstActiveTargetingSkill();
        }
        return this.targetingSkill;
    }

    private ILockOnTarget getFirstActiveTargetingSkill() {
        for (SkillBase skill : SkillRegistry.getValues()) {
            SkillBase instance;
            if (!(skill instanceof ILockOnTarget) || !(skill instanceof SkillActive) || (instance = this.getPlayerSkill(skill)) == null || !((SkillActive)instance).isActive()) continue;
            return (ILockOnTarget)((Object)instance);
        }
        return null;
    }

    public boolean grantSkill(SkillBase skill) {
        return this.grantSkill(skill, (byte)(this.getTrueSkillLevel(skill) + 1));
    }

    public boolean grantSkill(SkillBase skill, byte targetLevel) {
        SkillBase instance;
        byte id = skill.getId();
        SkillBase skillBase = instance = this.skills.containsKey(id) ? this.skills.get(id) : skill.newInstance();
        if (instance.grantSkill(this.player, targetLevel)) {
            this.skills.put(id, instance);
            return true;
        }
        return false;
    }

    public boolean activateSkill(SkillBase skill, boolean wasTriggered) {
        return skill instanceof SkillActive && this.onSkillActivated((SkillActive)skill, wasTriggered);
    }

    private boolean onSkillActivated(SkillActive skill, boolean wasTriggered) {
        if (skill.trigger(this.player.field_70170_p, this.player, wasTriggered)) {
            if (this.player.field_70170_p.field_72995_K && skill.isActive()) {
                this.setCurrentlyAnimatingSkill(skill);
            }
            return true;
        }
        return false;
    }

    public final boolean isSkillDisabled(@Nullable SkillBase skill) {
        return skill != null && this.disabledSkillIds.contains(skill.getId());
    }

    public Set<Byte> getDisabledSkillIds() {
        return Collections.unmodifiableSet(this.disabledSkillIds);
    }

    @SideOnly(value=Side.CLIENT)
    public void toggleDisabledSkill(SkillBase skill) {
        if (this.disabledSkillIds.contains(skill.getId())) {
            this.disabledSkillIds.remove(skill.getId());
        } else {
            this.disabledSkillIds.add(skill.getId());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void syncDisabledSkills() {
        PacketDispatcher.sendToServer(new SyncDisabledSkillsPacket(this.player));
    }

    public void setDisabledSkills(Set<Byte> disabledIds) {
        this.disabledSkillIds = disabledIds;
        this.validateSkills();
    }

    @SideOnly(value=Side.CLIENT)
    public void syncClientSideSkill(SkillBase skill) {
        if (skill != null) {
            if (skill.getLevel() > 0) {
                this.skills.put(skill.getId(), skill);
            } else {
                this.skills.remove(skill.getId());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(float partialRenderTick) {
        boolean flag = false;
        if (this.animatingSkill != null) {
            if (this.getSkillLevel(this.animatingSkill) < 1) {
                this.setCurrentlyAnimatingSkill(null);
            } else if (this.animatingSkill.isAnimating()) {
                flag = this.animatingSkill.onRenderTick(this.player, partialRenderTick);
            } else if (!this.animatingSkill.isActive()) {
                this.setCurrentlyAnimatingSkill(null);
            }
        }
        ILockOnTarget skill = this.getTargetingSkill();
        if (!flag && skill != null && skill.isLockedOn()) {
            ((SkillActive)((Object)skill)).onRenderTick(this.player, partialRenderTick);
        }
    }

    public void onUpdate() {
        this.updateISkillProvider();
        if (this.useItemCooldown > 0) {
            --this.useItemCooldown;
        }
        if (this.itemSkill != null) {
            this.itemSkill.onUpdate(this.player);
        }
        if (this.dummySwordSkill != null) {
            this.dummySwordSkill.onUpdate(this.player);
        }
        for (SkillBase skill : this.skills.values()) {
            skill.onUpdate(this.player);
        }
        if (this.invalidateCombo) {
            this.comboSkill = null;
            this.invalidateCombo = false;
        }
    }

    private void updateISkillProvider() {
        ItemStack stack = this.player.func_70694_bm();
        boolean skipUpdate = false;
        if (Skills.mortalDraw.is(this.itemSkill) && ((SkillActive)this.itemSkill).isActive()) {
            skipUpdate = true;
        } else if (stack == null) {
            this.lastCheckedStack = null;
            skipUpdate = this.retrieveDummySwordSkill();
        }
        if (!skipUpdate) {
            if (stack != null && stack.func_77973_b() instanceof ISkillProvider) {
                if (stack == this.lastCheckedStack) {
                    return;
                }
                this.lastCheckedStack = stack;
                ISkillProvider provider = (ISkillProvider)stack.func_77973_b();
                SkillBase skill = SkillBase.getSkillFromItem(stack, provider);
                if (this.itemSkill == null || !this.itemSkill.equals(skill)) {
                    this.itemSkill = skill.getLevel() > this.getTrueSkillLevel(skill) ? skill : null;
                }
                if (provider.grantsBasicSwordSkill(stack)) {
                    if (this.dummySwordSkill == null && !skill.is(Skills.swordBasic) && this.getTrueSkillLevel(Skills.swordBasic) < 1) {
                        this.dummySwordSkill = SkillBase.createLeveledSkill(Skills.swordBasic, (byte)1);
                    }
                } else if (this.dummySwordSkill != null) {
                    this.dummySwordSkill = null;
                }
            } else {
                this.dummySwordSkill = null;
                this.itemSkill = null;
                this.lastCheckedStack = null;
            }
        }
    }

    public void verifyStartingGear() {
        if (!this.receivedGear && Config.giveBonusOrb()) {
            int damage = ((IMetadataSkillItem)DynamicSwordSkills.skillOrb).getItemDamage(Skills.swordBasic);
            this.receivedGear = this.player.field_71071_by.func_70441_a(new ItemStack(DynamicSwordSkills.skillOrb, 1, damage));
        }
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new DSSPlayerInfo(player));
    }

    public static final DSSPlayerInfo get(EntityPlayer player) {
        return (DSSPlayerInfo)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void onPlayerLoggedIn() {
        this.verifyStartingGear();
    }

    public void onJoinWorld() {
        this.validateSkills();
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncPlayerInfoPacket(this), (EntityPlayerMP)this.player);
        }
    }

    public void copy(DSSPlayerInfo info) {
        NBTTagCompound compound = new NBTTagCompound();
        info.saveNBTData(compound);
        this.loadNBTData(compound);
    }

    public final void validateSkills() {
        for (SkillBase skill : this.skills.values()) {
            skill.validateSkill(this.player);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList taglist = new NBTTagList();
        for (SkillBase skill : this.skills.values()) {
            taglist.func_74742_a((NBTBase)skill.writeToNBT());
        }
        compound.func_74782_a("DynamicSwordSkills", (NBTBase)taglist);
        compound.func_74757_a("receivedGear", this.receivedGear);
        NBTTagList disabled = new NBTTagList();
        for (SkillBase skill : SkillRegistry.getValues()) {
            if (!this.disabledSkillIds.contains(skill.getId())) continue;
            disabled.func_74742_a((NBTBase)new NBTTagString(skill.getRegistryName().toString()));
        }
        compound.func_74782_a("UserDisabledSkills", (NBTBase)disabled);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.skills.clear();
        NBTTagList taglist = compound.func_150295_c("DynamicSwordSkills", 10);
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound tag = taglist.func_150305_b(i);
            SkillBase skill = SkillBase.loadFromNBT(tag);
            if (skill == null) continue;
            this.skills.put(skill.getId(), skill);
        }
        this.receivedGear = compound.func_74767_n("receivedGear");
        this.disabledSkillIds.clear();
        NBTTagList disabled = compound.func_150295_c("UserDisabledSkills", 8);
        for (int i = 0; i < disabled.func_74745_c(); ++i) {
            String s = disabled.func_150307_f(i);
            SkillBase skill = SkillRegistry.get(DynamicSwordSkills.getResourceLocation(s));
            if (skill == null) continue;
            this.disabledSkillIds.add(skill.getId());
        }
    }
}

