/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.command;

import com.google.common.collect.Lists;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.util.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ResourceLocation;

public class CommandGrantSkill
extends CommandBase {
    public static final ICommand INSTANCE = new CommandGrantSkill();

    public String func_71517_b() {
        return "grantskill";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender player) {
        return "commands.grantskill.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] args) {
        int level;
        if (args.length < 1 || args.length > 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP commandSender = CommandBase.func_71521_c((ICommandSender)sender);
        EntityPlayerMP player = args.length > 1 ? CommandBase.func_82359_c((ICommandSender)sender, (String)args[1]) : commandSender;
        DSSPlayerInfo skills = DSSPlayerInfo.get((EntityPlayer)player);
        int n = level = args.length < 3 ? 0 : CommandBase.func_71532_a((ICommandSender)sender, (String)args[2], (int)1, (int)100);
        if ("all".equals(args[0])) {
            String suffix;
            boolean flag = false;
            for (SkillBase skill : SkillRegistry.getValues()) {
                if (!Config.isSkillAllowed(skill)) continue;
                if (level < 1) {
                    if (!skills.grantSkill(skill)) continue;
                    flag = true;
                    continue;
                }
                byte lvl = (byte)Math.min(level, skill.getMaxLevel());
                if (!skills.grantSkill(skill, lvl)) continue;
                flag = true;
            }
            String string = suffix = level < 1 ? "one" : "lvl";
            if (flag) {
                PlayerUtils.sendTranslatedChat((EntityPlayer)player, "commands.grantskill.notify.all." + suffix, level);
                if (commandSender == player) return;
                PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantskill.success.all." + suffix, player.getDisplayName(), level);
                return;
            } else {
                PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantskill.failure.all." + suffix, player.getDisplayName(), level);
            }
            return;
        } else {
            SkillBase skill = SkillRegistry.get(DynamicSwordSkills.getResourceLocation(args[0]));
            if (skill == null) {
                throw new CommandException("commands.skill.generic.unknown", new Object[]{args[0]});
            }
            byte oldLevel = skills.getTrueSkillLevel(skill);
            int n2 = level = level < 1 ? oldLevel + 1 : level;
            if (level <= oldLevel) throw new CommandException("commands.grantskill.failure.low", new Object[]{player.func_70005_c_(), new ChatComponentTranslation(skill.getNameTranslationKey(), new Object[0]), (int)oldLevel});
            if (!Config.isSkillAllowed(skill)) {
                throw new CommandException("commands.grantskill.failure.disabled", new Object[]{new ChatComponentTranslation(skill.getNameTranslationKey(), new Object[0])});
            }
            if (!skills.grantSkill(skill, (byte)level)) throw new CommandException("commands.grantskill.failure.player", new Object[]{player.func_70005_c_(), new ChatComponentTranslation(skill.getNameTranslationKey(), new Object[0])});
            PlayerUtils.sendTranslatedChat((EntityPlayer)player, "commands.grantskill.notify.one", new ChatComponentTranslation(skill.getNameTranslationKey(), new Object[0]), skills.getTrueSkillLevel(skill));
            if (commandSender == player) return;
            PlayerUtils.sendTranslatedChat((EntityPlayer)commandSender, "commands.grantskill.success.one", player.func_70005_c_(), new ChatComponentTranslation(skill.getNameTranslationKey(), new Object[0]), skills.getTrueSkillLevel(skill));
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        switch (args.length) {
            case 1: {
                ArrayList options = Lists.newArrayList();
                for (ResourceLocation name : SkillRegistry.getKeys()) {
                    options.add(name.toString());
                }
                return CommandBase.func_71530_a((String[])args, (String[])options.toArray(new String[0]));
            }
            case 2: {
                return CommandBase.func_71530_a((String[])args, (String[])MinecraftServer.func_71276_C().func_71213_z());
            }
        }
        return null;
    }
}

