/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.GuiContainedElement;
import dynamicswordskills.client.gui.GuiElement;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTextElement
extends GuiContainedElement {
    public final IChatComponent text;
    public final int color;
    public final boolean isUnicode;
    public boolean isTextCentered;
    public boolean forceHover;
    public boolean isHoverable;
    public int hoverColor;
    public boolean drawTextShadow;
    protected List<String> lines;
    protected int contentHeight;
    protected int displayedHeight;
    protected int displayedWidth;

    public GuiTextElement(GuiElement parent, String text, int color, boolean isUnicode) {
        this(parent, (IChatComponent)new ChatComponentText(text), color, isUnicode);
    }

    public GuiTextElement(GuiElement parent, IChatComponent text, int color, boolean isUnicode) {
        this(parent.xPos, parent.yPos, parent.width, parent.height, text, color, isUnicode);
    }

    public GuiTextElement(int xPos, int yPos, int width, int height, IChatComponent text, int color, boolean isUnicode) {
        super(xPos, yPos, width, height);
        this.text = text;
        this.color = color;
        this.isUnicode = isUnicode;
        this.remainingHeight = height;
        this.remainingWidth = width - this.padding.width();
    }

    public GuiTextElement setCentered(boolean flag) {
        this.isTextCentered = flag;
        return this;
    }

    public GuiTextElement setHoverable(boolean flag) {
        this.isHoverable = flag;
        return this;
    }

    public GuiTextElement setHoverColor(int color) {
        this.hoverColor = color;
        return this;
    }

    public GuiTextElement setDrawTextShadown(boolean flag) {
        this.drawTextShadow = flag;
        return this;
    }

    @Override
    public int getContentHeight() {
        return this.contentHeight + this.padding.height();
    }

    @Override
    public int getContentWidth() {
        return this.width;
    }

    @Override
    public int getDisplayedHeight() {
        return this.displayedHeight;
    }

    @Override
    public int getDisplayedWidth() {
        return this.displayedWidth;
    }

    @Override
    public void setScrollableArea(int width, int height) {
        this.remainingHeight = height;
        this.remainingWidth = width - this.padding.width();
        if (this.lines == null) {
            Minecraft mc = Minecraft.func_71410_x();
            boolean unicodeFlag = mc.field_71466_p.func_82883_a();
            mc.field_71466_p.func_78264_a(this.isUnicode);
            this.lines = Lists.newArrayList();
            String formatting = this.text.func_150256_b().func_150218_j();
            for (String line : this.text.func_150260_c().split("\\\\n")) {
                List parts = mc.field_71466_p.func_78271_c(line, this.remainingWidth);
                for (String s : parts) {
                    this.lines.add(formatting + s + EnumChatFormatting.RESET);
                }
            }
            this.contentHeight = this.lines.size() * mc.field_71466_p.field_78288_b;
            mc.field_71466_p.func_78264_a(unicodeFlag);
        }
    }

    @Override
    public void drawElement(Minecraft mc, int mouseX, int mouseY) {
        if (this.lines == null) {
            this.setScrollableArea(this.width, this.height);
        }
        boolean unicodeFlag = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(this.isUnicode);
        int start = 0;
        int pY = this.padding.top;
        if (this.scrollY > 0) {
            pY = Math.max(0, pY - this.scrollY);
            this.scrollY -= this.padding.top;
            while (this.scrollY >= mc.field_71466_p.field_78288_b && start < this.lines.size()) {
                ++start;
                this.scrollY -= mc.field_71466_p.field_78288_b;
            }
            if (start < this.lines.size() && this.scrollY > 0 && this.scrollY < mc.field_71466_p.field_78288_b) {
                ++start;
                pY += mc.field_71466_p.field_78288_b - this.scrollY;
                this.scrollY -= mc.field_71466_p.field_78288_b;
            }
        }
        this.displayedHeight = pY;
        this.displayedWidth = this.remainingWidth;
        int innerX = this.xPos + this.padding.left;
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        int hoverHeight = Math.min(this.remainingHeight, this.padding.bottom + mc.field_71466_p.field_78288_b * (this.lines.size() - start));
        boolean hovered = this.isMouseOverElement(mouseX, mouseY, this.xPos, this.xPos + this.remainingWidth, this.yPos, this.yPos + pY + hoverHeight);
        for (int i = start; i < this.lines.size() && this.displayedHeight + mc.field_71466_p.field_78288_b <= this.remainingHeight; ++i) {
            String s = this.lines.get(i);
            int x = this.isTextCentered ? innerX + (this.remainingWidth - this.padding.width()) / 2 - mc.field_71466_p.func_78256_a(s) / 2 : innerX;
            int y = this.yPos + this.displayedHeight;
            this.drawLine(mc, mouseX, mouseY, s, x, y, hovered);
            this.displayedHeight += mc.field_71466_p.field_78288_b;
        }
        this.displayedHeight += this.padding.bottom - Math.max(0, this.scrollY);
        GL11.glEnable((int)2896);
        GL11.glPopAttrib();
        mc.field_71466_p.func_78264_a(unicodeFlag);
    }

    protected void drawLine(Minecraft mc, int mouseX, int mouseY, String line, int x, int y, boolean hovered) {
        if (this.forceHover) {
            if (this.drawTextShadow) {
                mc.field_71466_p.func_78261_a(line, x, y, this.hoverColor);
            } else {
                mc.field_71466_p.func_78276_b(line, x, y, this.hoverColor);
            }
        } else if (!hovered || !this.isHoverable) {
            mc.field_71466_p.func_78276_b(line, x, y, this.color);
        } else if (this.drawTextShadow) {
            mc.field_71466_p.func_78261_a(line, x, y, this.hoverColor);
        } else {
            mc.field_71466_p.func_78276_b(line, x, y, this.hoverColor);
        }
    }

    public static IChatComponent getBoldComponent(IChatComponent component, @Nullable EnumChatFormatting color) {
        return component.func_150255_a(component.func_150256_b().func_150227_a(Boolean.valueOf(true)).func_150238_a(color));
    }

    public static IChatComponent getItalicComponent(IChatComponent component, @Nullable EnumChatFormatting color) {
        return component.func_150255_a(component.func_150256_b().func_150217_b(Boolean.valueOf(true)).func_150238_a(color));
    }

    public static IChatComponent getStrikethroughComponent(IChatComponent component, @Nullable EnumChatFormatting color) {
        return component.func_150255_a(component.func_150256_b().func_150225_c(Boolean.valueOf(true)).func_150238_a(color));
    }

    public static IChatComponent getUnderlinedComponent(IChatComponent component, @Nullable EnumChatFormatting color) {
        return component.func_150255_a(component.func_150256_b().func_150228_d(Boolean.valueOf(true)).func_150238_a(color));
    }

    public static IChatComponent getStyledComponent(IChatComponent component, @Nullable EnumChatFormatting color, boolean bold, boolean italic, boolean underline, boolean strikethrough) {
        return component.func_150255_a(component.func_150256_b().func_150238_a(color).func_150227_a(Boolean.valueOf(bold)).func_150217_b(Boolean.valueOf(italic)).func_150228_d(Boolean.valueOf(underline)).func_150225_c(Boolean.valueOf(strikethrough)));
    }
}

