/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.GuiElement;
import dynamicswordskills.client.gui.GuiTextElement;
import dynamicswordskills.client.gui.IGuiContainedElement;
import dynamicswordskills.client.gui.IGuiElementScrollable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class GuiElementContainer<T extends IGuiContainedElement>
extends GuiElement
implements IGuiElementScrollable {
    protected final List<T> elements = Lists.newArrayList();
    protected int contentHeight;
    protected int contentWidth;
    protected int lineHeight;
    protected int lineWidth;
    protected int scrolledPixelsY;
    protected int scrolledPixelsX;
    protected int elementPadX;
    protected int elementPadY;
    protected boolean dirty;

    public GuiElementContainer(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
        this.markDirty();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public int getViewportHeight() {
        return this.height - this.padding.height();
    }

    public int getViewportWidth() {
        return this.width - this.padding.width();
    }

    @Override
    public int getScrollableWheelSpeed(boolean isHorizontal) {
        return Math.max(1, isHorizontal ? this.lineWidth : this.lineHeight);
    }

    @Override
    public boolean isScrollableByWheel(int mouseX, int mouseY, boolean isHorizontal) {
        return this.isMouseOverElement(mouseX, mouseY, 0, 0);
    }

    @Override
    public boolean isScrollControlRequired(boolean isHorizontal) {
        return isHorizontal ? this.getMaxScrollWidth() > 0 : this.getMaxScrollHeight() > 0;
    }

    protected boolean clampMaxScrollToLineHeight() {
        return false;
    }

    protected boolean clampMaxScrollToLineWidth() {
        return false;
    }

    @Override
    public int getMaxScrollHeight() {
        int i = this.contentHeight - this.padding.height() - this.getViewportHeight();
        if (i > 0 && this.lineHeight > 1 && this.clampMaxScrollToLineHeight()) {
            i = this.lineHeight * ((i + this.lineHeight - 1) / this.lineHeight);
        }
        return i;
    }

    @Override
    public int getMaxScrollWidth() {
        int i = this.contentWidth - this.padding.width() - this.getViewportWidth();
        if (i > 0 && this.lineWidth > 1 && this.clampMaxScrollToLineWidth()) {
            i = this.lineWidth * ((i + this.lineWidth - 1) / this.lineWidth);
        }
        return i;
    }

    @Override
    public void scrollElementTo(float scroll, boolean isHorizontal) {
        if (isHorizontal) {
            this.scrolledPixelsX = (int)(scroll * (float)this.getMaxScrollWidth());
        } else {
            this.scrolledPixelsY = (int)(scroll * (float)this.getMaxScrollHeight());
        }
    }

    protected void setupScrollableContainer(Minecraft mc, int mouseX, int mouseY) {
        for (IGuiContainedElement e : this.elements) {
            e.setScrollableArea(this.getViewportWidth(), this.getViewportHeight());
        }
        if (this.dirty) {
            this.contentHeight = this.calculateContentHeight();
            this.contentWidth = this.calculateContentWidth();
            this.scrollElementTo(0.0f, false);
            this.scrollElementTo(0.0f, true);
            this.dirty = false;
        }
    }

    public void setContainedElementSize(int width, int height) {
        if (this.lineWidth != width) {
            this.lineWidth = width;
            this.contentWidth = this.calculateContentWidth();
        }
        if (this.lineHeight != height) {
            this.lineHeight = height;
            this.contentHeight = this.calculateContentHeight();
        }
    }

    public GuiElementContainer<T> setElementPadding(int x, int y) {
        if (x != this.elementPadX) {
            this.markDirty();
            this.elementPadX = x;
        }
        if (y != this.elementPadY) {
            this.markDirty();
            this.elementPadY = y;
        }
        return this;
    }

    protected int calculateContentHeight() {
        int i = 0;
        for (IGuiContainedElement e : this.elements) {
            if (e.isElementExcluded()) continue;
            i += e.getContentHeight() + this.elementPadY;
        }
        if (i > 0) {
            i -= this.elementPadY;
        }
        return Math.max(this.height, this.padding.height() + i);
    }

    protected int calculateContentWidth() {
        return this.width;
    }

    @Override
    public void drawElement(Minecraft mc, int mouseX, int mouseY) {
        this.setupScrollableContainer(mc, mouseX, mouseY);
        int baseY = this.yPos + this.padding.top;
        int dy = 0;
        int scrollY = this.scrolledPixelsY;
        for (int i = 0; i < this.elements.size() && dy < this.getViewportHeight(); ++i) {
            IGuiContainedElement e = (IGuiContainedElement)this.elements.get(i);
            if (e.isElementExcluded()) continue;
            if (scrollY >= e.getContentHeight() + this.elementPadY) {
                scrollY -= e.getContentHeight() + this.elementPadY;
                continue;
            }
            if (!e.setRemainingDisplayArea(this.getViewportWidth(), this.getViewportHeight() - dy)) {
                dy += Math.max(0, e.getContentHeight() + this.elementPadY - Math.max(0, scrollY));
                continue;
            }
            e.setScrolledAmount(0, scrollY);
            scrollY -= e.getContentHeight() + this.elementPadY;
            e.setElementPosition(e.getElementPosX() + this.padding.left, baseY + dy);
            this.drawElement(e, mc, mouseX, mouseY);
            dy += e.getDisplayedHeight() + (i < this.elements.size() - 1 ? this.elementPadY : 0);
            e.setElementPosition(e.getElementPosX() - this.padding.left, e.getElementPosY());
        }
    }

    protected void drawElement(T element, Minecraft mc, int mouseX, int mouseY) {
        element.drawElement(mc, mouseX, mouseY);
    }

    public boolean canAdd(@Nullable T element) {
        return element != null;
    }

    public boolean add(@Nullable T element) {
        if (this.canAdd(element) && this.elements.add(element)) {
            this.onElementAdded(element);
            return true;
        }
        return false;
    }

    public T addAll(List<T> elements) {
        for (IGuiContainedElement t : elements) {
            if (this.add(t)) continue;
            return (T)t;
        }
        return null;
    }

    protected void onElementAdded(@Nullable T element) {
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public final List<T> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public static class GuiTextElementContainer
    extends GuiElementContainer<GuiTextElement> {
        public GuiTextElementContainer(int xPos, int yPos, int width, int height) {
            super(xPos, yPos, width, height);
        }

        @Override
        public void setupScrollableContainer(Minecraft mc, int mouseX, int mouseY) {
            super.setupScrollableContainer(mc, mouseX, mouseY);
            this.setContainedElementSize(this.width, mc.field_71466_p.field_78288_b);
        }

        @Override
        public int getScrollableWheelSpeed(boolean isHorizontal) {
            return this.lineHeight;
        }
    }
}

