/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.client.gui.GuiImageElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiButtonCustom
extends GuiButton {
    protected final ButtonBackgroundElement buttonElement;
    public final boolean isUnicode;
    public boolean drawButtonBox;
    public boolean drawLabelText;
    public boolean drawLabelShadow;

    public GuiButtonCustom(int id, int x, int y, int width, int height, String label) {
        this(id, x, y, width, height, label, true, false);
    }

    public GuiButtonCustom(int id, int x, int y, int width, int height, String label, boolean drawLabelShadow, boolean isUnicode) {
        super(id, x, y, width, height, label);
        this.drawLabelShadow = drawLabelShadow;
        this.isUnicode = isUnicode;
        this.buttonElement = new ButtonBackgroundElement(this);
    }

    public GuiButtonCustom setDrawButtonBox(boolean flag) {
        this.drawButtonBox = flag;
        return this;
    }

    public GuiButtonCustom setDrawLabelText(boolean flag) {
        this.drawLabelText = flag;
        return this;
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            this.drawBackground(mc, mouseX, mouseY);
            this.func_146119_b(mc, mouseX, mouseY);
            this.drawLabelText(mc, mouseX, mouseY);
        }
    }

    protected void drawLabelText(Minecraft mc, int mouseX, int mouseY) {
        if (this.drawLabelText) {
            boolean unicodeFlag = mc.field_71466_p.func_82883_a();
            mc.field_71466_p.func_78264_a(this.isUnicode);
            int dy = this.field_146121_g / 2 - mc.field_71466_p.field_78288_b / 2 - 1;
            this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + dy, this.getLabelColor());
            mc.field_71466_p.func_78264_a(unicodeFlag);
        }
    }

    protected void drawBackground(Minecraft mc, int mouseX, int mouseY) {
        if (this.drawButtonBox) {
            this.buttonElement.drawElement(mc, mouseX, mouseY);
        }
    }

    protected void drawHoveredGradient(int gradientColorTop, int gradientColorBot) {
        this.buttonElement.drawHoveredGradient(gradientColorTop, gradientColorBot);
    }

    public void func_73732_a(FontRenderer fontRenderer, String text, int x, int y, int color) {
        this.func_73731_b(fontRenderer, text, x - fontRenderer.func_78256_a(text) / 2, y, color);
    }

    public void func_73731_b(FontRenderer fontRenderer, String text, int x, int y, int color) {
        if (this.drawLabelShadow) {
            fontRenderer.func_78261_a(text, x, y, color);
        } else {
            fontRenderer.func_78276_b(text, x, y, color);
        }
    }

    public final int getLabelColor() {
        if (this.packedFGColour != 0) {
            return this.packedFGColour;
        }
        if (!this.field_146124_l) {
            return this.getDisabledLabelColor();
        }
        if (this.field_146123_n) {
            return this.getHoveredLabelColor();
        }
        return this.getDefaultLabelColor();
    }

    public int getDefaultLabelColor() {
        return 0xE0E0E0;
    }

    public int getDisabledLabelColor() {
        return 0xA0A0A0;
    }

    public int getHoveredLabelColor() {
        return 0xFFFFA0;
    }

    public static class ButtonBackgroundElement
    extends GuiImageElement {
        protected final GuiButtonCustom parent;

        public ButtonBackgroundElement(GuiButtonCustom button) {
            super(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g, field_146122_a, 256, 256, 0, 0);
            this.parent = button;
        }

        @Override
        protected void drawTexture(Minecraft mc, int mouseX, int mouseY, float f, int dx, int dy, int dw, int dh) {
            int i = this.parent.func_146114_a(this.parent.field_146123_n);
            mc.func_110434_K().func_110577_a(this.getTextureLocation());
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glBlendFunc((int)770, (int)771);
            int hw = this.width / 2;
            int ow = hw * 2 < this.width ? 1 : 0;
            int ty = dy + (46 + i * 20);
            int by = Math.max(0, 2 - dy);
            if (by > 0) {
                this.func_73729_b(this.xPos, this.yPos, 0, ty, hw + ow, by);
                this.func_73729_b(this.xPos + hw + ow, this.yPos, 200 - hw, ty, hw, by);
            }
            this.func_73729_b(this.xPos, this.yPos + by, 0, ty += 20 - (this.height - by), hw + ow, dh - by);
            this.func_73729_b(this.xPos + hw + ow, this.yPos + by, 200 - hw, ty, hw, dh - by);
        }
    }
}

