/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import dynamicswordskills.DynamicSwordSkills;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemSword;

public class WeaponRegistry {
    public static final String IMC_SWORD_KEY = "DssRegisterSword";
    public static final String IMC_WEAPON_KEY = "DssRegisterWeapon";
    private final Set<Item> swords = new HashSet<Item>();
    private final Set<Item> weapons = new HashSet<Item>();
    private final Set<Item> forbidden_swords = new HashSet<Item>();
    private final Set<Item> forbidden_weapons = new HashSet<Item>();
    public static final WeaponRegistry INSTANCE = new WeaponRegistry();

    private WeaponRegistry() {
    }

    public boolean isSword(Item item) {
        return !this.isSwordForbidden(item) && (item instanceof ItemSword || this.swords.contains(item));
    }

    public boolean isSwordForbidden(Item item) {
        return this.forbidden_swords.contains(item) || this.isWeaponForbidden(item);
    }

    public boolean isWeapon(Item item) {
        return !this.isWeaponForbidden(item) && (this.isSword(item) || item instanceof ItemAxe || this.weapons.contains(item));
    }

    public boolean isWeaponForbidden(Item item) {
        return this.forbidden_weapons.contains(item);
    }

    public void processMessage(FMLInterModComms.IMCMessage msg) {
        if (!msg.isItemStackMessage()) {
            return;
        }
        if (msg.key.equalsIgnoreCase(IMC_SWORD_KEY)) {
            this.registerSword("IMC", msg.getSender(), msg.getItemStackValue().func_77973_b());
        } else if (msg.key.equalsIgnoreCase(IMC_WEAPON_KEY)) {
            this.registerWeapon("IMC", msg.getSender(), msg.getItemStackValue().func_77973_b());
        }
    }

    public void registerItems(String[] names, String origin, boolean isSword) {
        this.processArray(names, origin, isSword, true);
    }

    public void forbidItems(String[] names, String origin, boolean isSword) {
        this.processArray(names, origin, isSword, false);
    }

    private void processArray(String[] names, String origin, boolean isSword, boolean register) {
        for (String s : names) {
            String[] parts = WeaponRegistry.parseString(s);
            if (parts == null) continue;
            Item item = GameRegistry.findItem((String)parts[0], (String)parts[1]);
            if (item == null) {
                DynamicSwordSkills.logger.warn(String.format("[WeaponRegistry] [%s] %s:%s could not be found - the mod may not be installed, or you may have typed it incorrectly", origin, parts[0], parts[1]));
                continue;
            }
            if (isSword) {
                if (register) {
                    this.registerSword(origin, parts[0], item);
                    continue;
                }
                this.removeSword(origin, parts[0], item);
                continue;
            }
            if (register) {
                this.registerWeapon(origin, parts[0], item);
                continue;
            }
            this.removeWeapon(origin, parts[0], item);
        }
    }

    public boolean registerSword(String origin, String modid, Item item) {
        boolean added = false;
        if (this.weapons.contains(item)) {
            DynamicSwordSkills.logger.warn(String.format("[WeaponRegistry] [%s] CONFLICT: %s:%s cannot be registered as a sword - it is already registered as a non-sword weapon", origin, modid, item.func_77658_a().replace("item.", "")));
        } else if (this.swords.add(item)) {
            DynamicSwordSkills.logger.info(String.format("[WeaponRegistry] [%s] Registered %s:%s as a sword", origin, modid, item.func_77658_a().replace("item.", "")));
            added = true;
        } else {
            DynamicSwordSkills.logger.warn(String.format("[WeaponRegistry] [%s] %s:%s has already been registered as a sword", origin, modid, item.func_77658_a().replace("item.", "")));
        }
        this.forbidden_swords.remove(item);
        return added;
    }

    public boolean registerWeapon(String origin, String modid, Item item) {
        boolean added = false;
        if (this.swords.contains(item)) {
            DynamicSwordSkills.logger.warn(String.format("[WeaponRegistry] [%s] CONFLICT: %s:%s cannot be registered as a weapon - it is already registered as a sword", origin, modid, item.func_77658_a().replace("item.", "")));
        } else if (this.weapons.add(item)) {
            DynamicSwordSkills.logger.info(String.format("[WeaponRegistry] [%s] Registered %s:%s as a non-sword weapon", origin, modid, item.func_77658_a().replace("item.", "")));
            added = true;
        } else {
            DynamicSwordSkills.logger.warn(String.format("[WeaponRegistry] [%s] %s:%s has already been registered as a weapon", origin, modid, item.func_77658_a().replace("item.", "")));
        }
        this.forbidden_weapons.remove(item);
        return added;
    }

    public boolean removeSword(String origin, String modid, Item item) {
        boolean added = false;
        if (this.forbidden_swords.add(item)) {
            added = true;
            DynamicSwordSkills.logger.info(String.format("[WeaponRegistry] [%s] %s:%s added to FORBIDDEN swords list", origin, modid, item.func_77658_a().replace("item.", "")));
        }
        if (this.swords.remove(item)) {
            DynamicSwordSkills.logger.info(String.format("[WeaponRegistry] [%s] Removed %s:%s from list of registered SWORDS", origin, modid, item.func_77658_a().replace("item.", "")));
            return true;
        }
        if (!added) {
            DynamicSwordSkills.logger.warn(String.format("[WeaponRegistry] [%s] Could not remove %s:%s - it was not registered as a sword", origin, modid, item.func_77658_a().replace("item.", "")));
        }
        return added;
    }

    public boolean removeWeapon(String origin, String modid, Item item) {
        boolean added = false;
        if (this.forbidden_weapons.add(item)) {
            added = true;
            DynamicSwordSkills.logger.info(String.format("[WeaponRegistry] [%s] %s:%s added to FORBIDDEN weapons list", origin, modid, item.func_77658_a().replace("item.", "")));
        }
        if (this.weapons.remove(item)) {
            DynamicSwordSkills.logger.info(String.format("[WeaponRegistry] [%s] Removed %s:%s from list of registered WEAPONS", origin, modid, item.func_77658_a().replace("item.", "")));
            return true;
        }
        if (!added) {
            DynamicSwordSkills.logger.warn(String.format("[WeaponRegistry] [%s] Could not remove %s:%s - it was not registered as a non-sword weapon", origin, modid, item.func_77658_a().replace("item.", "")));
        }
        return added;
    }

    public static String[] parseString(String itemid) {
        String[] parts = itemid.split(":");
        if (parts.length == 2) {
            return parts;
        }
        DynamicSwordSkills.logger.error(String.format("[WeaponRegistry] String must be in the format 'modid:registered_item_name', received: %s", itemid));
        return null;
    }
}

