/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;

public class SkillGroup {
    private static final Map<String, SkillGroup> map = Maps.newHashMap();
    public final String label;
    public int priority;
    protected String displayName;
    private boolean hasTooltip;

    public SkillGroup(String label) {
        this(label, -1);
    }

    public SkillGroup(String label, int priority) {
        Preconditions.checkArgument((label != null ? 1 : 0) != 0, (Object)"Group label can not be null");
        this.label = label;
        this.priority = priority;
    }

    public SkillGroup register() {
        if (SkillGroup.register(this)) {
            return this;
        }
        return SkillGroup.get(this.label);
    }

    public String getTranslationKey() {
        return "skillGroup." + this.label;
    }

    public String getDisplayName() {
        return this.displayName == null ? new ChatComponentTranslation(this.getTranslationKey(), new Object[0]).func_150260_c() : this.displayName;
    }

    public SkillGroup setDisplayName(String name) {
        this.displayName = name;
        return this;
    }

    public SkillGroup setHasTooltip() {
        this.hasTooltip = true;
        return this;
    }

    public List<String> getTooltip() {
        if (!this.hasTooltip) {
            return null;
        }
        return Lists.newArrayList((Object[])new String[]{this.getDisplayName(), EnumChatFormatting.GRAY + new ChatComponentTranslation(this.getTranslationKey() + ".tooltip", new Object[0]).func_150260_c()});
    }

    public final List<SkillBase> getSkills() {
        return this.getSkills(new Predicate<SkillBase>(){

            @Override
            public boolean test(SkillBase t) {
                return true;
            }
        });
    }

    public final List<SkillBase> getSkills(Predicate<SkillBase> filter) {
        ArrayList skills = Lists.newArrayList();
        for (SkillBase skill : SkillRegistry.getValues()) {
            if (!Config.isSkillInGroup(skill, this) || !filter.test(skill)) continue;
            skills.add(skill);
        }
        return skills;
    }

    public void sort(List<SkillBase> skills) {
        Collections.sort(skills, SkillRegistry.SORT_BY_REGISTRY_NAME);
    }

    public int hashCode() {
        return Objects.hash(this.label);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return ((SkillGroup)obj).label.equals(this.label);
    }

    private static final boolean register(SkillGroup group) {
        if (map.containsKey(group.label)) {
            return false;
        }
        map.put(group.label, group);
        return true;
    }

    public static final SkillGroup get(String label) {
        return map.get(label);
    }

    public static final List<SkillGroup> getAll() {
        ArrayList groups = Lists.newArrayList(map.values());
        Collections.sort(groups, new Comparator<SkillGroup>(){

            @Override
            public int compare(SkillGroup a, SkillGroup b) {
                return a == b ? 0 : (a.priority == b.priority ? a.label.compareTo(b.label) : b.priority - a.priority);
            }
        });
        return Collections.unmodifiableList(groups);
    }
}

