/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.api;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.IRandomSkill;
import dynamicswordskills.api.ISkillProviderInfusable;
import dynamicswordskills.api.SkillRegistry;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.SkillActive;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.Skills;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class ItemRandomSkill
extends ItemSword
implements IRandomSkill,
ISkillProviderInfusable {
    private static List<Byte> SKILLS = null;
    private final int quality;

    public ItemRandomSkill(Item.ToolMaterial material) {
        super(material);
        this.quality = material.func_77996_d() + (material == Item.ToolMaterial.GOLD ? 3 : 0);
        this.func_77637_a(null);
    }

    @Override
    public SkillBase getRandomSkill(Random rand) {
        if (SKILLS == null) {
            SKILLS = Lists.newArrayList();
            for (SkillBase skill : SkillRegistry.getValues()) {
                if (!Config.isSkillAllowed(skill) || !(skill instanceof SkillActive)) continue;
                SKILLS.add(skill.getId());
            }
        }
        if (SKILLS.size() > 0) {
            byte id = SKILLS.get(rand.nextInt(SKILLS.size()));
            return SkillRegistry.getSkillById(id);
        }
        return null;
    }

    @Override
    public boolean isSword(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isWeapon(ItemStack stack) {
        return true;
    }

    protected SkillBase getSkill(ItemStack stack) {
        return stack.func_77942_o() ? SkillBase.getSkillFromItem(stack, this) : null;
    }

    @Override
    public int getSkillId(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tag = stack.func_77978_p();
        SkillBase skill = null;
        if (tag.func_74764_b("ItemSkillName")) {
            String name = stack.func_77978_p().func_74779_i("ItemSkillName");
            if (name.lastIndexOf(58) == -1) {
                name = "dynamicswordskills:" + name;
                stack.func_77978_p().func_74778_a("ItemSkillName", name);
            }
            skill = SkillRegistry.get(DynamicSwordSkills.getResourceLocation(name));
        }
        if (skill == null && tag.func_74764_b("ItemSkillId") && (skill = SkillRegistry.getSkillById(tag.func_74762_e("ItemSkillId"))) != null) {
            tag.func_74778_a("ItemSkillName", skill.getRegistryName().toString());
            tag.func_82580_o("ItemSkillId");
        }
        return skill == null ? -1 : (int)skill.getId();
    }

    @Override
    public byte getSkillLevel(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("ItemSkillLevel") ? stack.func_77978_p().func_74771_c("ItemSkillLevel") : (byte)0;
    }

    @Override
    public boolean grantsBasicSwordSkill(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("grantsBasicSword");
    }

    @Override
    public int getInfusionCost(ItemStack stack, SkillBase skill) {
        if (skill.is(Skills.swordBasic) && !this.grantsBasicSwordSkill(stack)) {
            return 1;
        }
        if (!skill.is(this.getSkill(stack))) {
            return 0;
        }
        byte i = this.getSkillLevel(stack);
        return i < skill.getMaxLevel() ? i + 1 : 0;
    }

    @Override
    public ItemStack getInfusionResult(ItemStack stack, SkillBase skill) {
        ItemStack result = stack.func_77946_l();
        if (skill.is(Skills.swordBasic) && !this.grantsBasicSwordSkill(stack)) {
            result.func_77978_p().func_74757_a("grantsBasicSword", true);
        } else {
            int level = Math.min(skill.getMaxLevel(), this.getSkillLevel(stack) + 1);
            result.func_77978_p().func_74774_a("ItemSkillLevel", (byte)level);
        }
        return result;
    }

    public boolean isRepairable() {
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        SkillBase skill = this.getSkill(stack);
        return StatCollector.func_74837_a((String)(this.func_77667_c(stack) + ".name"), (Object[])new Object[]{skill == null ? "" : skill.getDisplayName()});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        SkillBase skill = this.getSkill(stack);
        if (skill != null) {
            list.add(StatCollector.func_74837_a((String)"tooltip.dss.skill_provider.desc.skill", (Object[])new Object[]{skill.getLevel(), EnumChatFormatting.GOLD + skill.getDisplayName() + EnumChatFormatting.GRAY}));
            if (this.grantsBasicSwordSkill(stack)) {
                String name = EnumChatFormatting.DARK_GREEN + Skills.swordBasic.getDisplayName() + EnumChatFormatting.GRAY;
                list.add(StatCollector.func_74837_a((String)"tooltip.dss.skill_provider.desc.provider", (Object[])new Object[]{name}));
            }
            if (advanced) {
                list.addAll(skill.getTooltip(player, true));
            }
        }
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rand, WeightedRandomChestContent original) {
        SkillBase skill = this.getRandomSkill(rand);
        if (skill == null) {
            return null;
        }
        ItemStack loot = new ItemStack((Item)this);
        this.generateSkillTag(loot, skill, rand);
        return new WeightedRandomChestContent(loot, original.field_76295_d, original.field_76296_e, original.field_76292_a);
    }

    public void generateSkillTag(ItemStack stack, SkillBase skill, Random rand) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("ItemSkillName", skill.getRegistryName().toString());
        int level = 1 + rand.nextInt(Math.min(this.quality + 2, skill.getMaxLevel()));
        tag.func_74774_a("ItemSkillLevel", (byte)level);
        boolean flag = !skill.is(Skills.swordBasic) && rand.nextInt(16) > 9 - this.quality;
        tag.func_74757_a("grantsBasicSword", flag);
    }
}

