/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.IMetadataSkillItem;
import dynamicswordskills.api.IRandomSkill;
import dynamicswordskills.entity.DSSPlayerInfo;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.client.SyncConfigPacket;
import dynamicswordskills.ref.Config;
import dynamicswordskills.skills.IComboSkill;
import dynamicswordskills.skills.SkillBase;
import dynamicswordskills.skills.Skills;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;

public class DSSCombatEvents {
    private static final Map<Class<? extends EntityLivingBase>, ItemStack> dropsList = new HashMap<Class<? extends EntityLivingBase>, ItemStack>();

    private static void addDrop(Class<? extends EntityLivingBase> mobClass, SkillBase skill) {
        int damage = ((IMetadataSkillItem)DynamicSwordSkills.skillOrb).getItemDamage(skill);
        if (damage > -1) {
            ItemStack stack = new ItemStack(DynamicSwordSkills.skillOrb, 1, damage);
            dropsList.put(mobClass, stack);
        }
    }

    public static void initializeDrops() {
        DSSCombatEvents.addDrop(EntityZombie.class, Skills.swordBasic);
        DSSCombatEvents.addDrop(EntitySkeleton.class, Skills.swordBasic);
        DSSCombatEvents.addDrop(EntityEnderman.class, Skills.dodge);
        DSSCombatEvents.addDrop(EntitySilverfish.class, Skills.backSlice);
        DSSCombatEvents.addDrop(EntitySlime.class, Skills.dash);
        DSSCombatEvents.addDrop(EntityHorse.class, Skills.dash);
        DSSCombatEvents.addDrop(EntityPigZombie.class, Skills.parry);
        DSSCombatEvents.addDrop(EntityOcelot.class, Skills.mortalDraw);
        DSSCombatEvents.addDrop(EntitySpider.class, Skills.endingBlow);
        DSSCombatEvents.addDrop(EntityCaveSpider.class, Skills.leapingBlow);
        DSSCombatEvents.addDrop(EntityMagmaCube.class, Skills.leapingBlow);
        DSSCombatEvents.addDrop(EntityBlaze.class, Skills.spinAttack);
        DSSCombatEvents.addDrop(EntityBat.class, Skills.risingCut);
        DSSCombatEvents.addDrop(EntityCreeper.class, Skills.armorBreak);
        DSSCombatEvents.addDrop(EntityIronGolem.class, Skills.swordBreak);
        DSSCombatEvents.addDrop(EntityGhast.class, Skills.superSpinAttack);
        DSSCombatEvents.addDrop(EntityWitch.class, Skills.swordBeam);
    }

    private static ItemStack getOrbDrop(EntityLivingBase mob) {
        if (dropsList.get(mob.getClass()) != null && mob.field_70170_p.field_73012_v.nextFloat() > Config.getChanceForRandomDrop()) {
            return dropsList.get(mob.getClass());
        }
        ItemStack orb = null;
        boolean flag = mob instanceof EntityPlayer;
        SkillBase skill = ((IRandomSkill)DynamicSwordSkills.skillOrb).getRandomSkill(mob.field_70170_p.field_73012_v);
        if (Config.isSkillAllowed(skill) && (!flag || Config.arePlayerDropsEnabled())) {
            int damage = ((IMetadataSkillItem)DynamicSwordSkills.skillOrb).getItemDamage(skill);
            float chance = (flag ? Config.getPlayerDropFactor() : 1.0f) * Config.getRandomMobDropChance();
            if (damage > -1 && (dropsList.get(mob.getClass()) != null || mob.field_70170_p.field_73012_v.nextFloat() < chance)) {
                orb = new ItemStack(DynamicSwordSkills.skillOrb, 1, damage);
            }
        }
        return orb;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        float baseChance;
        EntityLivingBase mob;
        ItemStack orb;
        if (event.source.func_76346_g() instanceof EntityPlayer && (orb = DSSCombatEvents.getOrbDrop(mob = event.entityLiving)) != null && (Config.areOrbDropsEnabled() || Config.arePlayerDropsEnabled() && event.entity instanceof EntityPlayer) && (baseChance = Config.getDropChance(orb.func_77960_j())) > 0.0f && mob.field_70170_p.field_73012_v.nextFloat() < baseChance + 0.005f * (float)event.lootingLevel) {
            event.drops.add(new EntityItem(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, orb.func_77946_l()));
            mob.field_70170_p.func_72908_a(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, "dynamicswordskills:special_drop", 1.0f, 1.0f);
        }
    }

    public static void setPlayerAttackTime(EntityPlayer player) {
        DSSPlayerInfo.get(player).setAttackCooldown(Config.getBaseSwingSpeed());
    }

    @SubscribeEvent
    public void onStartItemUse(PlayerUseItemEvent.Start event) {
        if (!DSSPlayerInfo.get(event.entityPlayer).canUseItem()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.source.func_76346_g()).onAttack(event);
        }
        if (!event.isCanceled() && event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.entity).onBeingAttacked(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onHurt(LivingHurtEvent event) {
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.source.func_76346_g()).onImpact(event);
            if (event.ammount <= 0.0f) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPostHurt(LivingHurtEvent event) {
        EntityPlayer player;
        IComboSkill combo;
        if (!event.isCanceled() && event.ammount > 0.0f && event.entity instanceof EntityPlayer && (combo = DSSPlayerInfo.get(player = (EntityPlayer)event.entity).getComboSkill()) != null && event.ammount > 0.0f) {
            combo.onPlayerHurt(player, event);
        }
        if (!event.isCanceled() && event.ammount > 0.0f && event.source.func_76346_g() instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.source.func_76346_g()).onPostImpact(event);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && DSSPlayerInfo.get((EntityPlayer)event.entity) == null) {
            DSSPlayerInfo.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        DSSPlayerInfo.get(event.player).onPlayerLoggedIn();
        if (event.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SyncConfigPacket(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.entity).onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        DSSPlayerInfo.get(event.entityPlayer).copy(DSSPlayerInfo.get(event.original));
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            DSSPlayerInfo.get((EntityPlayer)event.entity).onFall(event);
        }
    }

    @SubscribeEvent
    public void onCreativeFall(PlayerFlyableFallEvent event) {
        DSSPlayerInfo.get(event.entityPlayer).onCreativeFall(event);
    }
}

