/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;

public class DirtyEntityAccessor {
    public static void damageEntity(EntityLivingBase target, DamageSource source, float amount) {
        target.damageEntity(source, amount);
    }

    public static float getModifiedDamage(EntityLivingBase entity, DamageSource source, float amount) {
        if (!source.isUnblockable()) {
            int armor = 25 - entity.getTotalArmorValue();
            amount = amount * (float)armor / 25.0f;
        }
        amount = entity.applyPotionDamageCalculations(source, amount);
        return Math.max(amount - entity.getAbsorptionAmount(), 0.0f);
    }

    public static void setLivingXp(EntityLiving entity, int xp, boolean add) {
        entity.experienceValue = add ? entity.experienceValue + xp : xp;
    }
}

