/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TargetUtils {
    private static final int MAX_DISTANCE = 256;
    private static final double MAX_DISTANCE_SQ = 65536.0;

    public static double getReachDistanceSq(EntityPlayer player) {
        return player.capabilities.isCreativeMode ? 36.0 : 12.0;
    }

    public static boolean canReachTarget(EntityPlayer player, Entity target) {
        return player.canEntityBeSeen(target) && player.getDistanceSqToEntity(target) < TargetUtils.getReachDistanceSq(player);
    }

    public static MovingObjectPosition checkForImpact(World world, Entity entity, Entity shooter, double hitBox, boolean flag) {
        Vec3 vec3 = Vec3.createVectorHelper((double)entity.posX, (double)entity.posY, (double)entity.posZ);
        Vec3 vec31 = Vec3.createVectorHelper((double)(entity.posX + entity.motionX), (double)(entity.posY + entity.motionY), (double)(entity.posZ + entity.motionZ));
        MovingObjectPosition mop = world.func_147447_a(vec3, vec31, false, true, false);
        vec3 = Vec3.createVectorHelper((double)entity.posX, (double)entity.posY, (double)entity.posZ);
        vec31 = Vec3.createVectorHelper((double)(entity.posX + entity.motionX), (double)(entity.posY + entity.motionY - (double)entity.yOffset), (double)(entity.posZ + entity.motionZ));
        if (mop != null) {
            vec31 = Vec3.createVectorHelper((double)mop.hitVec.xCoord, (double)mop.hitVec.yCoord, (double)mop.hitVec.zCoord);
        }
        Entity target = null;
        List list = world.getEntitiesWithinAABBExcludingEntity(entity, entity.boundingBox.addCoord(entity.motionX, entity.motionY, entity.motionZ).expand(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition mop1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.canBeCollidedWith() || entity1 == shooter && !flag || (mop1 = (axisalignedbb = entity1.boundingBox.expand(hitBox, hitBox, hitBox)).calculateIntercept(vec3, vec31)) == null || !((d1 = vec3.distanceTo(mop1.hitVec)) < d0) && d0 != 0.0) continue;
            target = entity1;
            d0 = d1;
        }
        if (target != null) {
            mop = new MovingObjectPosition(target);
        }
        if (mop != null && mop.entityHit instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)mop.entityHit;
            if (player.capabilities.disableDamage || shooter instanceof EntityPlayer && !((EntityPlayer)shooter).canAttackPlayer(player)) {
                mop = null;
            }
        }
        return mop;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isMouseOverEntity(Entity entity) {
        MovingObjectPosition mop = Minecraft.getMinecraft().objectMouseOver;
        return mop != null && mop.entityHit == entity;
    }

    @SideOnly(value=Side.CLIENT)
    public static Entity getMouseOverEntity() {
        MovingObjectPosition mop = Minecraft.getMinecraft().objectMouseOver;
        return mop == null ? null : mop.entityHit;
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius) {
        return TargetUtils.acquireLookTarget(seeker, distance, radius, false);
    }

    public static final EntityLivingBase acquireLookTarget(EntityLivingBase seeker, int distance, double radius, boolean closestToSeeker) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        EntityLivingBase currentTarget = null;
        double currentDistance = 65536.0;
        Vec3 vec3 = seeker.getLookVec();
        double targetX = seeker.posX;
        double targetY = seeker.posY + (double)seeker.getEyeHeight() - (double)0.1f;
        double targetZ = seeker.posZ;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.lengthVector();
            List list = seeker.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, AxisAlignedBB.getBoundingBox((double)((targetX += vec3.xCoord) - radius), (double)((targetY += vec3.yCoord) - radius), (double)((targetZ += vec3.zCoord) - radius), (double)(targetX + radius), (double)(targetY + radius), (double)(targetZ + radius)));
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.canBeCollidedWith() || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target)) continue;
                double d = closestToSeeker ? target.getDistanceSqToEntity((Entity)seeker) : target.getDistanceSq(targetX, targetY, targetZ);
                double newDistance = d;
                if (!(newDistance < currentDistance)) continue;
                currentTarget = target;
                currentDistance = newDistance;
            }
        }
        return currentTarget;
    }

    public static final List<EntityLivingBase> acquireAllLookTargets(EntityLivingBase seeker, int distance, double radius) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        Vec3 vec3 = seeker.getLookVec();
        double targetX = seeker.posX;
        double targetY = seeker.posY + (double)seeker.getEyeHeight() - (double)0.1f;
        double targetZ = seeker.posZ;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.lengthVector();
            List list = seeker.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, AxisAlignedBB.getBoundingBox((double)((targetX += vec3.xCoord) - radius), (double)((targetY += vec3.yCoord) - radius), (double)((targetZ += vec3.zCoord) - radius), (double)(targetX + radius), (double)(targetY + radius), (double)(targetZ + radius)));
            for (EntityLivingBase target : list) {
                if (target == seeker || !target.canBeCollidedWith() || !TargetUtils.isTargetInSight(vec3, seeker, (Entity)target) || targets.contains(target)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    public static final boolean isTargetInFrontOf(Entity seeker, Entity target, float fov) {
        double dx = target.posX - seeker.posX;
        double dz = target.posZ - seeker.posZ;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - seeker.rotationYaw;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < fov && yaw > -fov;
    }

    public static final boolean isTargetInSight(EntityLivingBase seeker, Entity target) {
        return TargetUtils.isTargetInSight(seeker.getLookVec(), seeker, target);
    }

    private static final boolean isTargetInSight(Vec3 vec3, EntityLivingBase seeker, Entity target) {
        return seeker.canEntityBeSeen(target) && TargetUtils.isTargetInFrontOf((Entity)seeker, target, 60.0f);
    }

    public static ChunkCoordinates getEntityCoordinates(Entity entity) {
        int i = MathHelper.floor_double((double)(entity.posX + 0.5));
        int j = MathHelper.floor_double((double)(entity.posY + 0.5 - (entity.worldObj.isRemote ? (double)entity.yOffset : 0.0)));
        int k = MathHelper.floor_double((double)(entity.posZ + 0.5));
        return new ChunkCoordinates(i, j, k);
    }

    public static boolean isInLiquid(Entity entity) {
        ChunkCoordinates cc = TargetUtils.getEntityCoordinates(entity);
        Block block = entity.worldObj.getBlock(cc.posX, cc.posY, cc.posZ);
        return block.getMaterial().isLiquid();
    }

    public static final void knockTargetBack(EntityLivingBase pushedEntity, EntityLivingBase pushingEntity) {
        if (pushedEntity.canBePushed()) {
            double dx = pushedEntity.posX - pushingEntity.posX;
            double dz = pushedEntity.posZ - pushingEntity.posZ;
            while (dx * dx + dz * dz < 1.0E-4) {
                dx = (Math.random() - Math.random()) * 0.01;
                dz = (Math.random() - Math.random()) * 0.01;
            }
            pushedEntity.knockBack((Entity)pushingEntity, 0.0f, -dx, -dz);
        }
    }
}

