/*
 * Decompiled with CFR 0.152.
 */
package dynamicswordskills.util;

import dynamicswordskills.DynamicSwordSkills;
import dynamicswordskills.api.ISkillProvider;
import dynamicswordskills.api.IWeapon;
import dynamicswordskills.api.WeaponRegistry;
import dynamicswordskills.network.PacketDispatcher;
import dynamicswordskills.network.bidirectional.PlaySoundPacket;
import dynamicswordskills.skills.SkillBase;
import java.util.Random;
import mods.battlegear2.api.core.IBattlePlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PlayerUtils {
    public static boolean isBlocking(EntityPlayer player) {
        if (player.isBlocking()) {
            return true;
        }
        if (DynamicSwordSkills.isBG2Enabled) {
            return ((IBattlePlayer)player).isBattlemode() && ((IBattlePlayer)player).isBlockingWithShield();
        }
        return false;
    }

    public static boolean isSword(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getItem() instanceof IWeapon) {
            return ((IWeapon)stack.getItem()).isSword(stack);
        }
        return WeaponRegistry.INSTANCE.isSword(stack.getItem());
    }

    public static boolean isWeapon(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.getItem() instanceof IWeapon) {
            return ((IWeapon)stack.getItem()).isWeapon(stack);
        }
        return PlayerUtils.isSword(stack) || WeaponRegistry.INSTANCE.isWeapon(stack.getItem());
    }

    public static boolean isSwordOrProvider(ItemStack stack, SkillBase skill) {
        Item item = stack != null ? stack.getItem() : null;
        return PlayerUtils.isSword(stack) || item instanceof ISkillProvider && ((ISkillProvider)item).getSkillId(stack) == skill.getId();
    }

    public static float getHealthMissing(EntityPlayer player) {
        return player.capabilities.isCreativeMode ? 0.0f : player.getMaxHealth() - player.getHealth();
    }

    public static void sendTranslatedChat(EntityPlayer player, String message, Object ... args) {
        player.addChatMessage((IChatComponent)new ChatComponentTranslation(message, args));
    }

    public static void playSound(EntityPlayer player, String sound, float volume, float pitch) {
        if (player.worldObj.isRemote) {
            PacketDispatcher.sendToServer(new PlaySoundPacket(sound, volume, pitch, (Entity)player));
        } else {
            PacketDispatcher.sendTo(new PlaySoundPacket(sound, volume, pitch), (EntityPlayerMP)player);
        }
    }

    public static void playRandomizedSound(EntityPlayer player, String sound, float f, float add) {
        float volume = player.worldObj.rand.nextFloat() * f + add;
        float pitch = 1.0f / (player.worldObj.rand.nextFloat() * f + add);
        PlayerUtils.playSound(player, sound, volume, pitch);
    }

    public static void playSoundAtEntity(World world, Entity entity, String sound, float f, float add) {
        float volume = world.rand.nextFloat() * f + add;
        float pitch = 1.0f / (world.rand.nextFloat() * f + add);
        world.playSoundAtEntity(entity, sound, volume, pitch);
    }

    public static void spawnItemWithRandom(World world, ItemStack stack, double x, double y, double z) {
        if (!world.isRemote && stack != null) {
            double spawnX = x + (double)world.rand.nextFloat();
            double spawnY = y + (double)world.rand.nextFloat();
            double spawnZ = z + (double)world.rand.nextFloat();
            float f3 = 0.05f;
            EntityItem entityitem = new EntityItem(world, spawnX, spawnY, spawnZ, stack);
            entityitem.motionX = (-0.5 + world.rand.nextGaussian()) * (double)f3;
            entityitem.motionY = (4.0 + world.rand.nextGaussian()) * (double)f3;
            entityitem.motionZ = (-0.5 + world.rand.nextGaussian()) * (double)f3;
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
        }
    }

    public static void spawnXPOrbsWithRandom(World world, Random rand, int x, int y, int z, int xpAmount) {
        if (!world.isRemote) {
            while (xpAmount > 0) {
                int xp = xpAmount > 50 ? 50 : EntityXPOrb.getXPSplit((int)xpAmount);
                xpAmount -= xp;
                float spawnX = (float)x + rand.nextFloat();
                float spawnY = (float)y + rand.nextFloat();
                float spawnZ = (float)z + rand.nextFloat();
                EntityXPOrb xpOrb = new EntityXPOrb(world, (double)spawnX, (double)spawnY, (double)spawnZ, xp);
                xpOrb.motionY += (4.0 + rand.nextGaussian()) * (double)0.05f;
                world.spawnEntityInWorld((Entity)xpOrb);
            }
        }
    }

    public static void dropHeldItem(EntityLivingBase entity) {
        if (!entity.worldObj.isRemote && entity.getHeldItem() != null) {
            EntityItem drop = new EntityItem(entity.worldObj, entity.posX, entity.posY - (double)0.3f + (double)entity.getEyeHeight(), entity.posZ, entity.getHeldItem().copy());
            float f = 0.3f;
            float f1 = entity.worldObj.rand.nextFloat() * (float)Math.PI * 2.0f;
            drop.motionX = -MathHelper.sin((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f;
            drop.motionZ = MathHelper.cos((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f;
            drop.motionY = -MathHelper.sin((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f * entity.worldObj.rand.nextFloat();
            drop.motionX += Math.cos(f1) * (double)f;
            drop.motionY += (double)((entity.worldObj.rand.nextFloat() - entity.worldObj.rand.nextFloat()) * 0.1f);
            drop.motionZ += Math.sin(f1) * (double)f;
            drop.delayBeforeCanPickup = 40;
            entity.worldObj.spawnEntityInWorld((Entity)drop);
            entity.setCurrentItemOrArmor(0, (ItemStack)null);
        }
    }
}

